/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.common.base.Preconditions;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class GcpManagedChannelOptions {
    private static final Logger logger = Logger.getLogger(GcpManagedChannelOptions.class.getName());
    @Nullable
    private final GcpChannelPoolOptions channelPoolOptions;
    @Nullable
    private final GcpMetricsOptions metricsOptions;
    @Nullable
    private final GcpResiliencyOptions resiliencyOptions;

    public GcpManagedChannelOptions() {
        this.channelPoolOptions = null;
        this.metricsOptions = null;
        this.resiliencyOptions = null;
    }

    public GcpManagedChannelOptions(Builder builder) {
        this.channelPoolOptions = builder.channelPoolOptions;
        this.metricsOptions = builder.metricsOptions;
        this.resiliencyOptions = builder.resiliencyOptions;
    }

    @Nullable
    public GcpChannelPoolOptions getChannelPoolOptions() {
        return this.channelPoolOptions;
    }

    @Nullable
    public GcpMetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    @Nullable
    public GcpResiliencyOptions getResiliencyOptions() {
        return this.resiliencyOptions;
    }

    public String toString() {
        return String.format("{channelPoolOptions: %s, resiliencyOptions: %s, metricsOptions: %s}", this.getChannelPoolOptions(), this.getResiliencyOptions(), this.getMetricsOptions());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(GcpManagedChannelOptions options) {
        return new Builder(options);
    }

    public static class GcpResiliencyOptions {
        private final boolean notReadyFallbackEnabled;
        private final boolean unresponsiveDetectionEnabled;
        private final int unresponsiveDetectionMs;
        private final int unresponsiveDetectionDroppedCount;

        public GcpResiliencyOptions(Builder builder) {
            this.notReadyFallbackEnabled = builder.notReadyFallbackEnabled;
            this.unresponsiveDetectionEnabled = builder.unresponsiveDetectionEnabled;
            this.unresponsiveDetectionMs = builder.unresponsiveDetectionMs;
            this.unresponsiveDetectionDroppedCount = builder.unresponsiveDetectionDroppedCount;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(GcpResiliencyOptions options) {
            return new Builder(options);
        }

        public boolean isNotReadyFallbackEnabled() {
            return this.notReadyFallbackEnabled;
        }

        public boolean isUnresponsiveDetectionEnabled() {
            return this.unresponsiveDetectionEnabled;
        }

        public int getUnresponsiveDetectionMs() {
            return this.unresponsiveDetectionMs;
        }

        public int getUnresponsiveDetectionDroppedCount() {
            return this.unresponsiveDetectionDroppedCount;
        }

        public String toString() {
            return String.format("{notReadyFallbackEnabled: %s, unresponsiveDetectionEnabled: %s, unresponsiveDetectionMs: %d, unresponsiveDetectionDroppedCount: %d}", this.isNotReadyFallbackEnabled(), this.isUnresponsiveDetectionEnabled(), this.getUnresponsiveDetectionMs(), this.getUnresponsiveDetectionDroppedCount());
        }

        public static class Builder {
            private boolean notReadyFallbackEnabled = false;
            private boolean unresponsiveDetectionEnabled = false;
            private int unresponsiveDetectionMs = 0;
            private int unresponsiveDetectionDroppedCount = 0;

            public Builder() {
            }

            public Builder(GcpResiliencyOptions options) {
                this.notReadyFallbackEnabled = options.isNotReadyFallbackEnabled();
                this.unresponsiveDetectionEnabled = options.isUnresponsiveDetectionEnabled();
                this.unresponsiveDetectionMs = options.getUnresponsiveDetectionMs();
                this.unresponsiveDetectionDroppedCount = options.getUnresponsiveDetectionDroppedCount();
            }

            public GcpResiliencyOptions build() {
                return new GcpResiliencyOptions(this);
            }

            public Builder setNotReadyFallback(boolean enabled) {
                this.notReadyFallbackEnabled = enabled;
                return this;
            }

            public Builder withUnresponsiveConnectionDetection(int ms, int numDroppedRequests) {
                Preconditions.checkArgument((ms > 0 ? 1 : 0) != 0, (String)"ms should be > 0, got %s", (int)ms);
                Preconditions.checkArgument((numDroppedRequests > 0 ? 1 : 0) != 0, (String)"numDroppedRequests should be > 0, got %s", (int)numDroppedRequests);
                this.unresponsiveDetectionEnabled = true;
                this.unresponsiveDetectionMs = ms;
                this.unresponsiveDetectionDroppedCount = numDroppedRequests;
                return this;
            }

            public Builder disableUnresponsiveConnectionDetection() {
                this.unresponsiveDetectionEnabled = false;
                return this;
            }
        }
    }

    public static class GcpMetricsOptions {
        private final MetricRegistry metricRegistry;
        private final List<LabelKey> labelKeys;
        private final List<LabelValue> labelValues;
        private final String namePrefix;

        public GcpMetricsOptions(Builder builder) {
            this.metricRegistry = builder.metricRegistry;
            this.labelKeys = builder.labelKeys;
            this.labelValues = builder.labelValues;
            this.namePrefix = builder.namePrefix;
        }

        public MetricRegistry getMetricRegistry() {
            return this.metricRegistry;
        }

        public List<LabelKey> getLabelKeys() {
            return this.labelKeys;
        }

        public List<LabelValue> getLabelValues() {
            return this.labelValues;
        }

        public String getNamePrefix() {
            return this.namePrefix;
        }

        public String toString() {
            Iterator<LabelKey> keyIterator = this.getLabelKeys().iterator();
            Iterator<LabelValue> valueIterator = this.getLabelValues().iterator();
            ArrayList<String> labels = new ArrayList<String>();
            while (keyIterator.hasNext() && valueIterator.hasNext()) {
                labels.add(String.format("%s: \"%s\"", keyIterator.next().getKey(), valueIterator.next().getValue()));
            }
            return String.format("{namePrefix: \"%s\", labels: [%s], metricRegistry: %s}", this.getNamePrefix(), String.join((CharSequence)", ", labels), this.getMetricRegistry());
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(GcpMetricsOptions options) {
            return new Builder(options);
        }

        public static class Builder {
            private MetricRegistry metricRegistry;
            private List<LabelKey> labelKeys = new ArrayList<LabelKey>();
            private List<LabelValue> labelValues = new ArrayList<LabelValue>();
            private String namePrefix = "";

            public Builder() {
            }

            public Builder(GcpMetricsOptions options) {
                this();
                if (options == null) {
                    return;
                }
                this.metricRegistry = options.getMetricRegistry();
                this.labelKeys = options.getLabelKeys();
                this.labelValues = options.getLabelValues();
                this.namePrefix = options.getNamePrefix();
            }

            public GcpMetricsOptions build() {
                return new GcpMetricsOptions(this);
            }

            public Builder withMetricRegistry(MetricRegistry registry) {
                this.metricRegistry = registry;
                return this;
            }

            public Builder withLabels(List<LabelKey> labelKeys, List<LabelValue> labelValues) {
                if (labelKeys == null || labelValues == null || labelKeys.size() != labelValues.size()) {
                    logger.warning("Unable to set label keys and values - size mismatch or null.");
                    return this;
                }
                this.labelKeys = labelKeys;
                this.labelValues = labelValues;
                return this;
            }

            public Builder withNamePrefix(String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }
        }
    }

    public static class GcpChannelPoolOptions {
        private final int maxSize;
        private final int minSize;
        private final int concurrentStreamsLowWatermark;
        private final boolean useRoundRobinOnBind;
        private final Duration affinityKeyLifetime;
        private final Duration cleanupInterval;

        public GcpChannelPoolOptions(Builder builder) {
            this.maxSize = builder.maxSize;
            this.minSize = builder.minSize;
            this.concurrentStreamsLowWatermark = builder.concurrentStreamsLowWatermark;
            this.useRoundRobinOnBind = builder.useRoundRobinOnBind;
            this.affinityKeyLifetime = builder.affinityKeyLifetime;
            this.cleanupInterval = builder.cleanupInterval;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getConcurrentStreamsLowWatermark() {
            return this.concurrentStreamsLowWatermark;
        }

        public boolean isUseRoundRobinOnBind() {
            return this.useRoundRobinOnBind;
        }

        public Duration getAffinityKeyLifetime() {
            return this.affinityKeyLifetime;
        }

        public Duration getCleanupInterval() {
            return this.cleanupInterval;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(GcpChannelPoolOptions options) {
            return new Builder(options);
        }

        public String toString() {
            return String.format("{maxSize: %d, minSize: %d, concurrentStreamsLowWatermark: %d, useRoundRobinOnBind: %s}", this.getMaxSize(), this.getMinSize(), this.getConcurrentStreamsLowWatermark(), this.isUseRoundRobinOnBind());
        }

        public static class Builder {
            private int maxSize = 10;
            private int minSize = 0;
            private int concurrentStreamsLowWatermark = 100;
            private boolean useRoundRobinOnBind = false;
            private Duration affinityKeyLifetime = Duration.ZERO;
            private Duration cleanupInterval = Duration.ZERO;

            public Builder() {
            }

            public Builder(GcpChannelPoolOptions options) {
                this();
                if (options == null) {
                    return;
                }
                this.maxSize = options.getMaxSize();
                this.minSize = options.getMinSize();
                this.concurrentStreamsLowWatermark = options.getConcurrentStreamsLowWatermark();
                this.useRoundRobinOnBind = options.isUseRoundRobinOnBind();
                this.affinityKeyLifetime = options.getAffinityKeyLifetime();
                this.cleanupInterval = options.getCleanupInterval();
            }

            public GcpChannelPoolOptions build() {
                return new GcpChannelPoolOptions(this);
            }

            public Builder setMaxSize(int maxSize) {
                Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"Channel pool size must be positive.");
                this.maxSize = maxSize;
                return this;
            }

            public Builder setMinSize(int minSize) {
                Preconditions.checkArgument((minSize >= 0 ? 1 : 0) != 0, (Object)"Channel pool minimum size must be 0 or positive.");
                this.minSize = minSize;
                return this;
            }

            public Builder setConcurrentStreamsLowWatermark(int concurrentStreamsLowWatermark) {
                this.concurrentStreamsLowWatermark = concurrentStreamsLowWatermark;
                return this;
            }

            public Builder setUseRoundRobinOnBind(boolean enabled) {
                this.useRoundRobinOnBind = enabled;
                return this;
            }

            public Builder setAffinityKeyLifetime(Duration affinityKeyLifetime) {
                Preconditions.checkArgument((!affinityKeyLifetime.isNegative() ? 1 : 0) != 0, (Object)"Affinity key lifetime may not be negative.");
                this.affinityKeyLifetime = affinityKeyLifetime;
                if (!affinityKeyLifetime.isZero() && this.cleanupInterval.isZero()) {
                    this.cleanupInterval = affinityKeyLifetime.dividedBy(10L);
                }
                return this;
            }

            public Builder setCleanupInterval(Duration cleanupInterval) {
                Preconditions.checkArgument((!cleanupInterval.isNegative() ? 1 : 0) != 0, (Object)"Cleanup interval must not be negative.");
                Preconditions.checkArgument((!cleanupInterval.isZero() || this.affinityKeyLifetime.isZero() ? 1 : 0) != 0, (Object)"Cleanup interval must not be zero when affinity key interval is above zero.");
                this.cleanupInterval = cleanupInterval;
                return this;
            }
        }
    }

    public static class Builder {
        private GcpChannelPoolOptions channelPoolOptions;
        private GcpMetricsOptions metricsOptions;
        private GcpResiliencyOptions resiliencyOptions;

        public Builder() {
        }

        public Builder(GcpManagedChannelOptions options) {
            this.channelPoolOptions = options.getChannelPoolOptions();
            this.metricsOptions = options.getMetricsOptions();
            this.resiliencyOptions = options.getResiliencyOptions();
        }

        public GcpManagedChannelOptions build() {
            return new GcpManagedChannelOptions(this);
        }

        public Builder withChannelPoolOptions(GcpChannelPoolOptions channelPoolOptions) {
            this.channelPoolOptions = channelPoolOptions;
            return this;
        }

        public Builder withMetricsOptions(GcpMetricsOptions metricsOptions) {
            this.metricsOptions = metricsOptions;
            return this;
        }

        public Builder withResiliencyOptions(GcpResiliencyOptions resiliencyOptions) {
            this.resiliencyOptions = resiliencyOptions;
            return this;
        }
    }
}

