/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;

public final class TcpSslContextSpec
extends AbstractProtocolSslContextSpec<TcpSslContextSpec> {
    static final Consumer<SslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> sslCtxBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);

    public static TcpSslContextSpec forClient() {
        return new TcpSslContextSpec(SslContextBuilder.forClient());
    }

    public static TcpSslContextSpec forServer(File keyCertChainFile, File keyFile) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile));
    }

    public static TcpSslContextSpec forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)keyPassword));
    }

    public static TcpSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream));
    }

    public static TcpSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream, (String)keyPassword));
    }

    public static TcpSslContextSpec forServer(KeyManager keyManager) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((KeyManager)keyManager));
    }

    public static TcpSslContextSpec forServer(KeyManagerFactory keyManagerFactory) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, keyCertChain));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, keyCertChain));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, (X509Certificate[])keyCertChain));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (X509Certificate[])keyCertChain));
    }

    TcpSslContextSpec(SslContextBuilder sslContextBuilder) {
        super(sslContextBuilder);
    }

    @Override
    public TcpSslContextSpec get() {
        return this;
    }

    @Override
    protected Consumer<SslContextBuilder> defaultConfiguration() {
        return DEFAULT_CONFIGURATOR;
    }
}

