/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.oceanbase;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.OceanBaseDatabaseExtension;
import org.flywaydb.community.database.oceanbase.OceanBaseDatabase;
import org.flywaydb.community.database.oceanbase.OceanBaseJdbcUtils;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.database.mysql.MySQLDatabaseType;

public class OceanBaseDatabaseType
extends MySQLDatabaseType
implements CommunityDatabaseType {
    private static final String OB_JDBC_DRIVER = "com.oceanbase.jdbc.Driver";
    private static final String OB_LEGACY_JDBC_DRIVER = "com.alipay.oceanbase.jdbc.Driver";

    public String getName() {
        return "OceanBase";
    }

    public int getPriority() {
        return 1;
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:mysql:") || url.startsWith("jdbc:oceanbase:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return url.startsWith("jdbc:oceanbase:") ? OB_JDBC_DRIVER : super.getDriverClass(url, classLoader);
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        return url.startsWith("jdbc:oceanbase:") && ClassUtils.isPresent((String)OB_LEGACY_JDBC_DRIVER, (ClassLoader)classLoader) ? OB_LEGACY_JDBC_DRIVER : super.getBackupDriverClass(url, classLoader);
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        String versionComment;
        if (!databaseProductName.contains("MySQL") && !databaseProductName.contains("OceanBase")) {
            return false;
        }
        try {
            versionComment = OceanBaseJdbcUtils.getVersionComment(connection);
        }
        catch (SQLException e) {
            return false;
        }
        return versionComment != null && versionComment.contains("OceanBase");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new OceanBaseDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public String getPluginVersion(Configuration config) {
        return OceanBaseDatabaseExtension.readVersion();
    }
}

