/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.FlywayModel;
import org.flywaydb.core.internal.license.EncryptionUtils;
import org.flywaydb.core.internal.license.FlywayPermit;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.DockerUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class TelemetryUtils {
    public static RootTelemetryModel populateRootTelemetry(RootTelemetryModel rootTelemetryModel, Configuration configuration, FlywayPermit flywayPermit) {
        boolean isRGDomainSet;
        rootTelemetryModel.setApplicationVersion(VersionPrinter.getVersion());
        boolean bl = isRGDomainSet = System.getenv("RGDOMAIN") != null;
        if (flywayPermit != null) {
            rootTelemetryModel.setRedgateEmployee(flywayPermit.isRedgateEmployee() || isRGDomainSet);
            rootTelemetryModel.setApplicationEdition(Tier.asString((Tier)flywayPermit.getTier()));
            rootTelemetryModel.setTrial(flywayPermit.isTrial());
            rootTelemetryModel.setSignedIn(flywayPermit.isFromAuth());
        } else {
            rootTelemetryModel.setRedgateEmployee(isRGDomainSet);
        }
        if (configuration != null) {
            ConfigurationModel modernConfig = configuration.getModernConfig();
            if (modernConfig != null && StringUtils.hasText((String)modernConfig.getId())) {
                rootTelemetryModel.setProjectId(EncryptionUtils.hashString((String)modernConfig.getId(), (String)"fur"));
            }
            boolean resolversPresent = configuration.getResolvers().length != 0;
            rootTelemetryModel.setCustomMigrationResolver(resolversPresent);
            rootTelemetryModel.setSecretsManagementType(TelemetryUtils.getSecretsManagementType(configuration));
            HashMap<String, Boolean> customParameters = new HashMap<String, Boolean>();
            FlywayModel defaults = FlywayModel.defaults();
            customParameters.put("validateOnMigrate", configuration.isValidateOnMigrate() != defaults.getValidateOnMigrate().booleanValue());
            customParameters.put("validateMigrationNaming", configuration.isValidateMigrationNaming() != defaults.getValidateMigrationNaming().booleanValue());
            customParameters.put("target", !Objects.equals(configuration.getTarget().getName(), defaults.getTarget()));
            customParameters.put("stream", configuration.isStream() != defaults.getStream().booleanValue());
            customParameters.put("reportEnabled", configuration.isReportEnabled() != defaults.getReportEnabled().booleanValue());
            customParameters.put("lockRetryCount", configuration.getLockRetryCount() != defaults.getLockRetryCount().intValue());
            customParameters.put("failOnMissingLocations", configuration.isFailOnMissingLocations() != defaults.getFailOnMissingLocations().booleanValue());
            customParameters.put("outputQueryResults", configuration.isOutputQueryResults() != defaults.getOutputQueryResults().booleanValue());
            customParameters.put("batch", configuration.isBatch() != defaults.getBatch().booleanValue());
            customParameters.put("createSchemas", configuration.isCreateSchemas() != defaults.getCreateSchemas().booleanValue());
            customParameters.put("baselineOnMigrate", configuration.isBaselineOnMigrate() != defaults.getBaselineOnMigrate().booleanValue());
            customParameters.put("group", configuration.isGroup() != defaults.getGroup().booleanValue());
            customParameters.put("mixed", configuration.isMixed() != defaults.getMixed().booleanValue());
            customParameters.put("outOfOrder", configuration.isOutOfOrder() != defaults.getOutOfOrder().booleanValue());
            customParameters.put("communityDBSupportEnabled", configuration.isCommunityDBSupportEnabled() != defaults.getCommunityDBSupportEnabled().booleanValue());
            customParameters.put("skipDefaultResolvers", configuration.isSkipDefaultResolvers() != defaults.getSkipDefaultResolvers().booleanValue());
            customParameters.put("skipDefaultCallbacks", configuration.isSkipDefaultCallbacks() != defaults.getSkipDefaultCallbacks().booleanValue());
            customParameters.put("skipExecutingMigrations", configuration.isSkipExecutingMigrations() != defaults.getSkipExecutingMigrations().booleanValue());
            customParameters.put("executeInTransaction", configuration.isExecuteInTransaction() != defaults.getExecuteInTransaction().booleanValue());
            customParameters.put("encoding", !Objects.equals(configuration.getEncoding().name(), defaults.getEncoding()));
            customParameters.put("detectEncoding", configuration.isDetectEncoding() != defaults.getDetectEncoding().booleanValue());
            customParameters.put("table", !Objects.equals(configuration.getTable(), defaults.getTable()));
            ArrayList parameterNames = new ArrayList();
            customParameters.forEach((paramName, isSet) -> {
                if (isSet.booleanValue()) {
                    parameterNames.add(paramName);
                }
            });
            rootTelemetryModel.setCustomParameters(String.join((CharSequence)",", parameterNames));
        }
        rootTelemetryModel.setContainerType(DockerUtils.getContainerType(x$0 -> Paths.get(x$0, new String[0])));
        return rootTelemetryModel;
    }

    public static String getOldestMigration(List<InfoOutput> infos) {
        if (infos == null) {
            return "";
        }
        ArrayList migrationDates = new ArrayList();
        infos.stream().filter(output -> StringUtils.hasText((String)output.installedOnUTC)).forEach(output -> migrationDates.add(output.installedOnUTC));
        if (!migrationDates.isEmpty()) {
            migrationDates.sort(Comparator.naturalOrder());
            return (String)migrationDates.get(0);
        }
        return "";
    }

    private static String getSecretsManagementType(Configuration configuration) {
        return "None";
    }

    private TelemetryUtils() {
    }
}

