/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.specex;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ConstantSpeculativeExecutionPolicy
implements SpeculativeExecutionPolicy {
    private final int maxExecutions;
    private final long constantDelayMillis;

    public ConstantSpeculativeExecutionPolicy(DriverContext context, String profileName) {
        DriverExecutionProfile config = context.getConfig().getProfile(profileName);
        this.maxExecutions = config.getInt(DefaultDriverOption.SPECULATIVE_EXECUTION_MAX);
        if (this.maxExecutions < 1) {
            throw new IllegalArgumentException("Max must be at least 1");
        }
        this.constantDelayMillis = config.getDuration(DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY).toMillis();
        if (this.constantDelayMillis < 0L) {
            throw new IllegalArgumentException("Delay must be positive or 0");
        }
    }

    @Override
    public long nextExecution(@NonNull Node node, @Nullable CqlIdentifier keyspace, @NonNull Request request, int runningExecutions) {
        assert (runningExecutions >= 1);
        return runningExecutions < this.maxExecutions ? this.constantDelayMillis : -1L;
    }

    @Override
    public void close() {
    }
}

