/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.base.Stopwatch;
import com.google.rpc.Code;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

abstract class AbstractJdbcStatement
extends AbstractJdbcWrapper
implements java.sql.Statement {
    private static final String CURSORS_NOT_SUPPORTED = "Cursors are not supported";
    private static final String ONLY_FETCH_FORWARD_SUPPORTED = "Only fetch_forward is supported";
    final AbstractStatementParser parser;
    private boolean closed;
    private boolean closeOnCompletion;
    private boolean poolable;
    private final JdbcConnection connection;
    private int queryTimeout;
    private static final TimeUnit[] SUPPORTED_UNITS = new TimeUnit[]{TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};

    AbstractJdbcStatement(JdbcConnection connection) throws SQLException {
        this.connection = connection;
        this.parser = connection.getParser();
    }

    @Override
    public JdbcConnection getConnection() {
        return this.connection;
    }

    private Options.QueryOption[] getQueryOptions(Options.QueryOption ... options) throws SQLException {
        Options.QueryOption[] res;
        Options.QueryOption[] queryOptionArray = res = options == null ? new Options.QueryOption[]{} : options;
        if (this.getFetchSize() > 0) {
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = Options.prefetchChunks((int)this.getFetchSize());
        }
        return res;
    }

    private TimeUnit getAppropriateTimeUnit() {
        int index = 0;
        if (this.connection.getSpannerConnection().hasStatementTimeout()) {
            for (TimeUnit unit : SUPPORTED_UNITS) {
                long duration = this.connection.getSpannerConnection().getStatementTimeout(unit);
                if (index + 1 < SUPPORTED_UNITS.length) {
                    if (duration > 0L && duration * 1000L == this.connection.getSpannerConnection().getStatementTimeout(SUPPORTED_UNITS[index + 1])) {
                        return unit;
                    }
                } else {
                    return unit;
                }
                ++index;
            }
            throw new IllegalStateException("Unsupported duration");
        }
        return null;
    }

    protected <T> T runWithStatementTimeout(JdbcFunction<Connection, T> function) throws SQLException {
        this.checkClosed();
        StatementTimeout originalTimeout = this.setTemporaryStatementTimeout();
        try {
            T t = function.apply(this.getConnection().getSpannerConnection());
            return t;
        }
        catch (SpannerException spannerException) {
            throw JdbcSqlExceptionFactory.of(spannerException);
        }
        finally {
            this.resetStatementTimeout(originalTimeout);
        }
    }

    StatementTimeout setTemporaryStatementTimeout() throws SQLException {
        StatementTimeout originalTimeout = null;
        if (this.getQueryTimeout() > 0) {
            if (this.connection.getSpannerConnection().hasStatementTimeout()) {
                TimeUnit unit = this.getAppropriateTimeUnit();
                originalTimeout = StatementTimeout.of(this.connection.getSpannerConnection().getStatementTimeout(unit), unit);
            }
            this.connection.getSpannerConnection().setStatementTimeout((long)this.getQueryTimeout(), TimeUnit.SECONDS);
        }
        return originalTimeout;
    }

    void resetStatementTimeout(StatementTimeout originalTimeout) throws SQLException {
        if (this.getQueryTimeout() > 0) {
            if (originalTimeout == null) {
                this.connection.getSpannerConnection().clearStatementTimeout();
            } else {
                this.connection.getSpannerConnection().setStatementTimeout(originalTimeout.timeout, originalTimeout.unit);
            }
        }
    }

    java.sql.ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode) throws SQLException {
        return this.executeQuery(statement, analyzeMode, new Options.QueryOption[0]);
    }

    java.sql.ResultSet executeQuery(Statement statement, Options.QueryOption ... options) throws SQLException {
        return this.executeQuery(statement, (ReadContext.QueryAnalyzeMode)null, options);
    }

    private java.sql.ResultSet executeQuery(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.QueryOption ... options) throws SQLException {
        Options.QueryOption[] queryOptions = this.getQueryOptions(options);
        return this.doWithStatementTimeout(() -> {
            ResultSet resultSet = analyzeMode == null ? this.connection.getSpannerConnection().executeQuery(statement, queryOptions) : this.connection.getSpannerConnection().analyzeQuery(statement, analyzeMode);
            return JdbcResultSet.of(this, resultSet);
        });
    }

    private <T> T doWithStatementTimeout(Supplier<T> runnable) throws SQLException {
        return (T)this.doWithStatementTimeout(runnable, ignore -> Boolean.TRUE);
    }

    private <T> T doWithStatementTimeout(Supplier<T> runnable, Function<T, Boolean> shouldResetTimeout) throws SQLException {
        StatementTimeout originalTimeout = this.setTemporaryStatementTimeout();
        T result = null;
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            result = runnable.get();
            Duration executionDuration = stopwatch.elapsed();
            this.connection.recordClientLibLatencyMetric(executionDuration.toMillis());
            T t = result;
            return t;
        }
        catch (SpannerException spannerException) {
            throw JdbcSqlExceptionFactory.of(spannerException);
        }
        finally {
            if (shouldResetTimeout.apply(result).booleanValue()) {
                this.resetStatementTimeout(originalTimeout);
            }
        }
    }

    int checkedCast(long updateCount) throws SQLException {
        if (updateCount > Integer.MAX_VALUE) {
            throw JdbcSqlExceptionFactory.of("update count too large for executeUpdate: " + updateCount, Code.OUT_OF_RANGE);
        }
        return (int)updateCount;
    }

    StatementResult execute(Statement statement) throws SQLException {
        StatementResult statementResult = this.doWithStatementTimeout(() -> this.connection.getSpannerConnection().execute(statement), result -> !this.resultIsSetStatementTimeout((StatementResult)result));
        if (this.resultIsShowStatementTimeout(statementResult)) {
            return this.rerunShowStatementTimeout(statement);
        }
        return statementResult;
    }

    private boolean resultIsSetStatementTimeout(StatementResult result) {
        return result != null && result.getClientSideStatementType() == StatementResult.ClientSideStatementType.SET_STATEMENT_TIMEOUT;
    }

    private boolean resultIsShowStatementTimeout(StatementResult result) {
        return result != null && result.getClientSideStatementType() == StatementResult.ClientSideStatementType.SHOW_STATEMENT_TIMEOUT;
    }

    private StatementResult rerunShowStatementTimeout(Statement statement) throws SQLException {
        try {
            return this.connection.getSpannerConnection().execute(statement);
        }
        catch (SpannerException spannerException) {
            throw JdbcSqlExceptionFactory.of(spannerException);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        this.connection.getSpannerConnection().cancel();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkClosed();
        return 0L;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw JdbcSqlExceptionFactory.unsupported(CURSORS_NOT_SUPPORTED);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw JdbcSqlExceptionFactory.unsupported(ONLY_FETCH_FORWARD_SUPPORTED);
        }
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    static class StatementTimeout {
        private final long timeout;
        private final TimeUnit unit;

        private static StatementTimeout of(long timeout, TimeUnit unit) {
            return new StatementTimeout(timeout, unit);
        }

        private StatementTimeout(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.unit = unit;
        }
    }

    static interface JdbcFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

