/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.common.base.Preconditions;
import com.google.rpc.Code;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Wrapper;
import java.util.Calendar;

abstract class AbstractJdbcWrapper
implements Wrapper {
    static final String OTHER_NAME = "OTHER";
    private static final String OUT_OF_RANGE_MSG = "Value out of range for %s: %s";

    AbstractJdbcWrapper() {
    }

    static int extractColumnType(Type type) {
        Preconditions.checkNotNull((Object)type);
        switch (JdbcTypeConverter.getMainTypeCode(type)) {
            case BOOL: {
                return 16;
            }
            case BYTES: 
            case PROTO: {
                return -2;
            }
            case DATE: {
                return 91;
            }
            case FLOAT32: {
                return 7;
            }
            case FLOAT64: {
                return 8;
            }
            case INT64: 
            case ENUM: {
                return -5;
            }
            case NUMERIC: 
            case PG_NUMERIC: {
                return 2;
            }
            case STRING: 
            case JSON: 
            case PG_JSONB: {
                return -9;
            }
            case TIMESTAMP: {
                return 93;
            }
            case ARRAY: {
                return 2003;
            }
        }
        return 1111;
    }

    static String getSpannerTypeName(Type type, Dialect dialect) {
        return ((Type)Preconditions.checkNotNull((Object)type)).getSpannerTypeName(dialect);
    }

    @Deprecated
    static String getSpannerTypeName(int sqlType) {
        if (sqlType == 16) {
            return Type.bool().getCode().name();
        }
        if (sqlType == -2) {
            return Type.bytes().getCode().name();
        }
        if (sqlType == 91) {
            return Type.date().getCode().name();
        }
        if (sqlType == 7) {
            return Type.float32().getCode().name();
        }
        if (sqlType == 8 || sqlType == 6) {
            return Type.float64().getCode().name();
        }
        if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
            return Type.int64().getCode().name();
        }
        if (sqlType == 2 || sqlType == 3) {
            return Type.numeric().getCode().name();
        }
        if (sqlType == -9) {
            return Type.string().getCode().name();
        }
        if (sqlType == 93 || sqlType == 2014) {
            return Type.timestamp().getCode().name();
        }
        if (sqlType == 2003) {
            return Type.Code.ARRAY.name();
        }
        return OTHER_NAME;
    }

    @Deprecated
    static String getClassName(int sqlType) {
        if (sqlType == 16) {
            return Boolean.class.getName();
        }
        if (sqlType == -2) {
            return Byte[].class.getName();
        }
        if (sqlType == 91) {
            return java.sql.Date.class.getName();
        }
        if (sqlType == 7) {
            return Float.class.getName();
        }
        if (sqlType == 8 || sqlType == 6) {
            return Double.class.getName();
        }
        if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
            return Long.class.getName();
        }
        if (sqlType == 2 || sqlType == 3) {
            return BigDecimal.class.getName();
        }
        if (sqlType == -9) {
            return String.class.getName();
        }
        if (sqlType == 93 || sqlType == 2014) {
            return java.sql.Timestamp.class.getName();
        }
        if (sqlType == 2003) {
            return Object.class.getName();
        }
        return null;
    }

    static String getClassName(Type type) {
        Preconditions.checkNotNull((Object)type);
        switch (JdbcTypeConverter.getMainTypeCode(type)) {
            case BOOL: {
                return Boolean.class.getName();
            }
            case BYTES: 
            case PROTO: {
                return byte[].class.getName();
            }
            case DATE: {
                return java.sql.Date.class.getName();
            }
            case FLOAT32: {
                return Float.class.getName();
            }
            case FLOAT64: {
                return Double.class.getName();
            }
            case INT64: 
            case ENUM: {
                return Long.class.getName();
            }
            case NUMERIC: 
            case PG_NUMERIC: {
                return BigDecimal.class.getName();
            }
            case STRING: 
            case JSON: 
            case PG_JSONB: {
                return String.class.getName();
            }
            case TIMESTAMP: {
                return java.sql.Timestamp.class.getName();
            }
            case ARRAY: {
                switch (JdbcTypeConverter.getMainTypeCode(type.getArrayElementType())) {
                    case BOOL: {
                        return Boolean[].class.getName();
                    }
                    case BYTES: 
                    case PROTO: {
                        return byte[][].class.getName();
                    }
                    case DATE: {
                        return java.sql.Date[].class.getName();
                    }
                    case FLOAT32: {
                        return Float[].class.getName();
                    }
                    case FLOAT64: {
                        return Double[].class.getName();
                    }
                    case INT64: 
                    case ENUM: {
                        return Long[].class.getName();
                    }
                    case NUMERIC: 
                    case PG_NUMERIC: {
                        return BigDecimal[].class.getName();
                    }
                    case STRING: 
                    case JSON: 
                    case PG_JSONB: {
                        return String[].class.getName();
                    }
                    case TIMESTAMP: {
                        return java.sql.Timestamp[].class.getName();
                    }
                }
            }
        }
        return null;
    }

    static byte checkedCastToByte(long val) throws SQLException {
        if (val > 127L || val < -128L) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "byte", val), Code.OUT_OF_RANGE);
        }
        return (byte)val;
    }

    static byte checkedCastToByte(BigDecimal val) throws SQLException {
        try {
            return val.byteValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "byte", val), Code.OUT_OF_RANGE);
        }
    }

    static byte checkedCastToByte(BigInteger val) throws SQLException {
        try {
            return val.byteValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "byte", val), Code.OUT_OF_RANGE);
        }
    }

    static short checkedCastToShort(long val) throws SQLException {
        if (val > 32767L || val < -32768L) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "short", val), Code.OUT_OF_RANGE);
        }
        return (short)val;
    }

    static short checkedCastToShort(BigDecimal val) throws SQLException {
        try {
            return val.shortValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "short", val), Code.OUT_OF_RANGE);
        }
    }

    static short checkedCastToShort(BigInteger val) throws SQLException {
        try {
            return val.shortValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "short", val), Code.OUT_OF_RANGE);
        }
    }

    static int checkedCastToInt(long val) throws SQLException {
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "int", val), Code.OUT_OF_RANGE);
        }
        return (int)val;
    }

    static int checkedCastToInt(BigDecimal val) throws SQLException {
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "int", val), Code.OUT_OF_RANGE);
        }
    }

    static int checkedCastToInt(BigInteger val) throws SQLException {
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "int", val), Code.OUT_OF_RANGE);
        }
    }

    static float checkedCastToFloat(double val) throws SQLException {
        if (val > 3.4028234663852886E38 || val < -3.4028234663852886E38) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "float", val), Code.OUT_OF_RANGE);
        }
        return (float)val;
    }

    static long parseLong(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid number", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static BigInteger checkedCastToBigInteger(BigDecimal val) throws SQLException {
        try {
            return val.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "BigInteger", val), Code.OUT_OF_RANGE);
        }
    }

    static long checkedCastToLong(BigDecimal val) throws SQLException {
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "long", val), Code.OUT_OF_RANGE);
        }
    }

    static long checkedCastToLong(BigInteger val) throws SQLException {
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException e) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "long", val), Code.OUT_OF_RANGE);
        }
    }

    static double parseDouble(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid number", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static float parseFloat(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid number", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Date parseDate(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return JdbcTypeConverter.toSqlDate(Date.parseDate((String)val));
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid date", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Date parseDate(String val, Calendar cal) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        Preconditions.checkNotNull((Object)cal);
        try {
            return JdbcTypeConverter.toSqlDate(Date.parseDate((String)val), cal);
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid date", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static Time parseTime(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Time.valueOf(val);
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid time", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static Time parseTime(String val, Calendar cal) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        Preconditions.checkNotNull((Object)cal);
        try {
            return JdbcTypeConverter.parseSqlTime(val, cal);
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid time", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Timestamp parseTimestamp(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return JdbcTypeConverter.toSqlTimestamp(Timestamp.parseTimestamp((String)val));
        }
        catch (Exception e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid timestamp", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Timestamp parseTimestamp(String val, Calendar cal) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        Preconditions.checkNotNull((Object)cal);
        try {
            return JdbcTypeConverter.setTimestampInCalendar(Timestamp.parseTimestamp((String)val).toSqlTimestamp(), cal);
        }
        catch (Exception e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid timestamp", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static BigDecimal parseBigDecimal(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return new BigDecimal(val);
        }
        catch (NumberFormatException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid number", val), Code.INVALID_ARGUMENT, e);
        }
    }

    public abstract boolean isClosed();

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw JdbcSqlExceptionFactory.of("This " + this.getClass().getName() + " has been closed", Code.FAILED_PRECONDITION);
        }
    }

    <T> T checkClosedAndThrowUnsupported(String message) throws SQLException {
        this.checkClosed();
        throw JdbcSqlExceptionFactory.unsupported(message);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw JdbcSqlExceptionFactory.of("Cannot unwrap to " + iface.getName(), Code.INVALID_ARGUMENT);
    }
}

