/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.baseline;

import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.verb.VerbUtils;
import org.flywaydb.verb.schemas.SchemasVerbExtension;

public class BaselineVerbExtension
implements VerbExtension {
    private static final Log LOG = LogFactory.getLog(BaselineVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "baseline".equals(verb);
    }

    public Object executeVerb(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        BaselineResult baselineResult;
        block14: {
            ExperimentalDatabase experimentalDatabase;
            try {
                experimentalDatabase = VerbUtils.getExperimentalDatabase((Configuration)configuration);
            }
            catch (Exception e) {
                throw new FlywayException((Throwable)e);
            }
            ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)flywayTelemetryManager, (MetaData)experimentalDatabase.getDatabaseMetaData());
            baselineResult = new BaselineResult(VersionPrinter.getVersion(), experimentalDatabase.getDatabaseMetaData().databaseName());
            MigrationVersion baselineVersion = configuration.getBaselineVersion();
            String schemaHistoryName = configuration.getTable();
            if (configuration.isCreateSchemas()) {
                boolean schemaHistoryTablePreExisting = experimentalDatabase.schemaHistoryTableExists(schemaHistoryName);
                new SchemasVerbExtension().executeVerb(configuration, flywayTelemetryManager);
                if (!schemaHistoryTablePreExisting) {
                    BaselineVerbExtension.createBaselineMarker(configuration, experimentalDatabase, baselineResult);
                    return baselineResult;
                }
            } else {
                LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://documentation.red-gate.com/fd/migrations-184127470.html");
            }
            boolean schemaHistoryTableExists = experimentalDatabase.schemaHistoryTableExists(schemaHistoryName);
            try {
                if (!schemaHistoryTableExists) {
                    BaselineVerbExtension.createBaselineMarker(configuration, experimentalDatabase, baselineResult);
                    return baselineResult;
                }
                SchemaHistoryModel schemaHistoryModel = experimentalDatabase.getSchemaHistoryModel(schemaHistoryName);
                String schemaHistoryText = experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema()}) + "." + experimentalDatabase.quote(new String[]{schemaHistoryName});
                boolean baselinePresent = schemaHistoryModel.getSchemaHistoryItems().stream().anyMatch(x -> CoreMigrationType.BASELINE.name().equals(x.getType()));
                boolean onlySchemas = schemaHistoryModel.getSchemaHistoryItems().stream().allMatch(x -> CoreMigrationType.SCHEMA.name().equals(x.getType()));
                if (baselinePresent) {
                    String baselineDescription = configuration.getBaselineDescription();
                    SchemaHistoryItem baselineMarker = schemaHistoryModel.getSchemaHistoryItems().stream().filter(x -> CoreMigrationType.BASELINE.name().equals(x.getType())).findFirst().get();
                    if (baselineVersion.getVersion().equals(baselineMarker.getVersion()) && baselineDescription.equals(baselineMarker.getDescription())) {
                        LOG.info("Schema history table " + schemaHistoryText + " already initialized with (" + baselineVersion + "," + baselineDescription + "). Skipping.");
                        baselineResult.successfullyBaselined = true;
                        baselineResult.baselineVersion = baselineVersion.toString();
                        break block14;
                    }
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " with (" + baselineVersion + "," + baselineDescription + ") as it has already been baselined with (" + baselineMarker.getVersion() + "," + baselineMarker.getDescription() + ")\nNeed to reset your baseline? Learn more: https://rd.gt/3CdwkXD");
                }
                boolean schemaPresent = schemaHistoryModel.getSchemaHistoryItems().stream().anyMatch(x -> CoreMigrationType.SCHEMA.name().equals(x.getType()));
                if (schemaPresent && baselineVersion.equals((Object)MigrationVersion.fromVersion((String)"0"))) {
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " with version 0 as this version was used for schema creation");
                }
                boolean nonSyntheticMigrations = schemaHistoryModel.getSchemaHistoryItems().stream().anyMatch(x -> !CoreMigrationType.fromString((String)x.getType()).isSynthetic());
                if (nonSyntheticMigrations) {
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " as it already contains migrations\nNeed to reset your baseline? Learn more: https://rd.gt/3CdwkXD");
                }
                if (schemaHistoryModel.getSchemaHistoryItems().isEmpty()) {
                    throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " as it already exists, and is empty.\nDelete the schema history table, and run baseline again.");
                }
                if (onlySchemas) {
                    BaselineVerbExtension.createBaselineMarker(configuration, experimentalDatabase, baselineResult);
                    break block14;
                }
                throw new FlywayException("Unable to baseline schema history table " + schemaHistoryText + " as it already contains migrations.\nDelete the schema history table, and run baseline again.\nNeed to reset your baseline? Learn more: https://rd.gt/3CdwkXD");
            }
            catch (FlywayException e) {
                baselineResult.successfullyBaselined = false;
                throw e;
            }
        }
        return baselineResult;
    }

    private static void createBaselineMarker(Configuration configuration, ExperimentalDatabase experimentalDatabase, BaselineResult baselineResult) {
        experimentalDatabase.createSchemaHistoryTableIfNotExists(configuration.getTable());
        String baselineVersion = configuration.getBaselineVersion().getVersion();
        experimentalDatabase.appendSchemaHistoryItem(SchemaHistoryItem.builder().description(configuration.getBaselineDescription()).installedRank(1).type("BASELINE").script("<< Flyway Baseline >>").installedBy(experimentalDatabase.getInstalledBy(configuration)).version(baselineVersion).executionTime(0).success(true).build(), configuration.getTable());
        LOG.info("Successfully baselined schema with version: " + baselineVersion);
        baselineResult.successfullyBaselined = true;
        baselineResult.baselineVersion = baselineVersion;
    }
}

