/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.databricks;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.databricks.DatabricksConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;

public class DatabricksDatabase
extends Database<DatabricksConnection> {
    public DatabricksDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected DatabricksConnection doGetConnection(Connection connection) {
        return new DatabricksConnection(this, connection);
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((DatabricksConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT current_user() as user;", new String[0]);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + StringUtils.replaceAll((String)identifier, (String)this.getCloseQuote(), (String)this.getEscapedQuote()) + this.getCloseQuote();
    }

    protected String getOpenQuote() {
        return "`";
    }

    protected String getCloseQuote() {
        return "`";
    }

    public String getEscapedQuote() {
        return "\\`";
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String sql = "CREATE TABLE " + table + " (\n    `installed_rank` INT NOT NULL,\n    `version` STRING,\n    `description` STRING NOT NULL,\n    `type` STRING NOT NULL,\n    `script` STRING NOT NULL,\n    `checksum` INT,\n    `installed_by` STRING NOT NULL,\n    `installed_on` TIMESTAMP NOT NULL,\n    `execution_time` INT NOT NULL,\n    `success` BOOLEAN NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "");
        return sql;
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP(), ?, ?)";
    }
}

