/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.clean;

import java.util.Arrays;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.command.clean.SchemaModel;

public class CleanModel {
    private SchemaModel schemas = null;
    private String mode = null;

    public void validate() {
        try {
            if (this.mode != null) {
                CleanModeConfigurationExtension.Mode.valueOf(this.mode);
            }
        }
        catch (IllegalArgumentException e) {
            throw new FlywayException("Unknown clean mode: " + this.mode);
        }
    }

    public void setMode(String mode) {
        this.mode = mode != null ? mode.toUpperCase() : null;
    }

    public void setCleanSchemasExclude(String ... cleanSchemasExclude) {
        this.setSchemas(new SchemaModel());
        this.schemas.setExclude(Arrays.asList(cleanSchemasExclude));
    }

    public SchemaModel getSchemas() {
        return this.schemas;
    }

    public void setSchemas(SchemaModel schemas) {
        this.schemas = schemas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CleanModel)) {
            return false;
        }
        CleanModel other = (CleanModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SchemaModel this$schemas = this.getSchemas();
        SchemaModel other$schemas = other.getSchemas();
        if (this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CleanModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SchemaModel $schemas = this.getSchemas();
        result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    public String toString() {
        return "CleanModel(schemas=" + this.getSchemas() + ", mode=" + this.getMode() + ")";
    }

    public String getMode() {
        return this.mode;
    }
}

