/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;

public class DbClean {
    private static final Log LOG = LogFactory.getLog(DbClean.class);
    private final Connection connection;
    private final SchemaHistory schemaHistory;
    private final Schema[] schemas;
    private final List<FlywayCallback> callbacks;
    private boolean cleanDisabled;

    public DbClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, List<FlywayCallback> callbacks, boolean cleanDisabled) {
        this.connection = database.getMainConnection();
        this.schemaHistory = schemaHistory;
        this.schemas = schemas;
        this.callbacks = callbacks;
        this.cleanDisabled = cleanDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws FlywayException {
        if (this.cleanDisabled) {
            throw new FlywayException("Unable to execute clean as it has been disabled with the \"flyway.cleanDisabled\" property.");
        }
        try {
            for (final FlywayCallback callback : this.callbacks) {
                new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

                    @Override
                    public Object call() throws SQLException {
                        DbClean.this.connection.changeCurrentSchemaTo(DbClean.this.schemas[0]);
                        callback.beforeClean(DbClean.this.connection.getJdbcConnection());
                        return null;
                    }
                });
            }
            this.connection.changeCurrentSchemaTo(this.schemas[0]);
            boolean dropSchemas = false;
            try {
                dropSchemas = this.schemaHistory.hasSchemasMarker();
            }
            catch (Exception e) {
                LOG.error("Error while checking whether the schemas should be dropped", e);
            }
            for (Schema schema : this.schemas) {
                if (!schema.exists()) {
                    LOG.warn("Unable to clean unknown schema: " + schema);
                    continue;
                }
                if (dropSchemas) {
                    this.dropSchema(schema);
                    continue;
                }
                this.cleanSchema(schema);
            }
            for (final FlywayCallback callback : this.callbacks) {
                new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

                    @Override
                    public Object call() throws SQLException {
                        DbClean.this.connection.changeCurrentSchemaTo(DbClean.this.schemas[0]);
                        callback.afterClean(DbClean.this.connection.getJdbcConnection());
                        return null;
                    }
                });
            }
            this.schemaHistory.clearCache();
        }
        finally {
            this.connection.restoreCurrentSchema();
        }
    }

    private void dropSchema(final Schema schema) {
        LOG.debug("Dropping schema " + schema + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

            @Override
            public Void call() {
                schema.drop();
                return null;
            }
        });
        stopWatch.stop();
        LOG.info(String.format("Successfully dropped schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }

    private void cleanSchema(final Schema schema) {
        LOG.debug("Cleaning schema " + schema + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

            @Override
            public Void call() {
                schema.clean();
                return null;
            }
        });
        stopWatch.stop();
        LOG.info(String.format("Successfully cleaned schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }
}

