/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.h2;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.h2.H2Connection;
import org.flywaydb.core.internal.database.h2.H2SqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.util.scanner.Resource;

public class H2Database
extends Database {
    public H2Database(FlywayConfiguration configuration, java.sql.Connection connection) {
        super(configuration, connection, 12);
    }

    protected Connection getConnection(java.sql.Connection connection, int nullType) {
        return new H2Connection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 1 || this.majorVersion == 1 && this.minorVersion < 2) {
            throw new FlywayDbUpgradeRequiredException("H2", version, "1.2.137");
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(Resource sqlScriptResource, String sqlScriptSource, boolean mixed) {
        return new H2SqlScript(sqlScriptResource, sqlScriptSource, mixed);
    }

    @Override
    public String getDbName() {
        return "h2";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.mainConnection.getJdbcTemplate().queryForString("SELECT USER()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

