/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sybasease;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.sybasease.SybaseASEConnection;
import org.flywaydb.core.internal.database.sybasease.SybaseASESqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.util.scanner.Resource;

public class SybaseASEDatabase
extends Database<SybaseASEConnection> {
    public SybaseASEDatabase(FlywayConfiguration configuration, Connection connection, boolean jconnect) {
        super(configuration, connection, jconnect ? 12 : 0);
    }

    @Override
    protected SybaseASEConnection getConnection(Connection connection, int nullType) {
        return new SybaseASEConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 15 || this.majorVersion == 15 && this.minorVersion < 7) {
            throw new FlywayDbUpgradeRequiredException("Sybase ASE", version, "15.7");
        }
        if (this.majorVersion > 16 || this.majorVersion == 16 && this.minorVersion > 2) {
            this.recommendFlywayUpgrade("Sybase ASE", version);
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(Resource sqlScriptResource, String sqlScriptSource, boolean mixed) {
        return new SybaseASESqlScript(sqlScriptResource, sqlScriptSource, mixed);
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return new Delimiter("GO", true);
    }

    @Override
    public String getDbName() {
        return "sybasease";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((SybaseASEConnection)this.mainConnection).getJdbcTemplate().queryForString("SELECT user_name()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    protected String doQuote(String identifier) {
        return identifier;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

