/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.Table;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBTable;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;

public class CockroachDBSchema
extends Schema<CockroachDBDatabase> {
    CockroachDBSchema(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT EXISTS ( SELECT 1 FROM pg_database WHERE datname=? )", this.name);
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        if (((CockroachDBDatabase)this.database).getMajorVersion() == 1) {
            return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables  WHERE table_schema=?  AND table_type='BASE TABLE')", this.name);
        }
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables   WHERE table_catalog=?  AND table_schema='public'  AND table_type='BASE TABLE')", this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE DATABASE " + ((CockroachDBDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP DATABASE " + ((CockroachDBDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (Table table : this.allTables()) {
            table.drop();
        }
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace LEFT JOIN pg_depend dep ON dep.objid = c.oid AND dep.deptype = 'e' WHERE c.relkind = 'v' AND n.nspname = 'public' AND dep.objid IS NULL", new String[0]);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP VIEW IF EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name, domainName) + " CASCADE");
        }
        return statements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        String query = ((CockroachDBDatabase)this.database).getMajorVersion() == 1 ? "SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'" : "SELECT table_name FROM information_schema.tables WHERE table_catalog=? AND table_schema='public' AND table_type='BASE TABLE'";
        List<String> tableNames = this.jdbcTemplate.queryForStringList(query, this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new CockroachDBTable(this.jdbcTemplate, this.database, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new CockroachDBTable(this.jdbcTemplate, this.database, this, tableName);
    }
}

