/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final Database database;
    private final PlaceholderReplacer placeholderReplacer;
    private final LoadableResource resource;
    private final Configuration configuration;
    private SqlScript sqlScript;

    SqlMigrationExecutor(Database database, LoadableResource resource, PlaceholderReplacer placeholderReplacer, Configuration configuration) {
        this.database = database;
        this.resource = resource;
        this.placeholderReplacer = placeholderReplacer;
        this.configuration = configuration;
    }

    @Override
    public void execute(Connection connection) {
        this.getSqlScript().execute(((org.flywaydb.core.internal.database.Connection)this.database.getMigrationConnection()).getJdbcTemplate());
    }

    private synchronized SqlScript getSqlScript() {
        if (this.sqlScript == null) {
            this.sqlScript = this.database.createSqlScript(this.resource, this.placeholderReplacer, this.configuration.isMixed());
        }
        return this.sqlScript;
    }

    @Override
    public boolean executeInTransaction() {
        return this.getSqlScript().executeInTransaction();
    }
}

