/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\f', '\r'};

    private StringUtils() {
    }

    public static String trimOrPad(String str, int length) {
        return StringUtils.trimOrPad(str, length, ' ');
    }

    public static String trimOrPad(String str, int length, char padChar) {
        StringBuilder result = str == null ? new StringBuilder() : new StringBuilder(str);
        if (result.length() > length) {
            return result.substring(0, length);
        }
        while (result.length() < length) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static boolean isNumeric(String str) {
        return str != null && str.matches("\\d*");
    }

    public static String collapseWhitespace(String str) {
        StringBuilder result = new StringBuilder();
        int previous = 0;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            boolean whitespace = false;
            for (char w : WHITESPACE_CHARS) {
                if (c != w) continue;
                if (previous != 32) {
                    result.append(' ');
                }
                previous = 32;
                whitespace = true;
                break;
            }
            if (whitespace) continue;
            result.append((char)c);
            previous = c;
        }
        return result.toString();
    }

    public static String left(String str, int count) {
        if (str == null) {
            return null;
        }
        if (str.length() < count) {
            return str;
        }
        return str.substring(0, count);
    }

    public static String replaceAll(String str, String originalToken, String replacementToken) {
        return str.replaceAll(Pattern.quote(originalToken), Matcher.quoteReplacement(replacementToken));
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static String arrayToCommaDelimitedString(Object[] strings) {
        return StringUtils.arrayToDelimitedString(",", strings);
    }

    public static String arrayToDelimitedString(String delimiter, Object[] strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(String.valueOf(strings[i]));
        }
        return builder.toString();
    }

    public static boolean hasText(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        Collection<String> tokens = StringUtils.tokenizeToStringCollection(str, delimiters);
        return tokens.toArray(new String[0]);
    }

    public static Collection<String> tokenizeToStringCollection(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>(str.length() / 5);
        char[] delimiterChars = delimiters.toCharArray();
        int start = 0;
        int end = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean delimiter = false;
            for (char d : delimiterChars) {
                if (c != d) continue;
                tokens.add(str.substring(start, end));
                end = start = i + 1;
                delimiter = true;
                break;
            }
            if (delimiter) continue;
            if (i == start && c == ' ') {
                ++start;
                ++end;
            }
            if (i < start || c == ' ') continue;
            end = i + 1;
        }
        if (start < end) {
            tokens.add(str.substring(start, end));
        }
        return tokens;
    }

    public static int countOccurrencesOf(String str, String token) {
        int idx;
        if (str == null || token == null || str.length() == 0 || token.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(token, pos)) != -1) {
            ++count;
            pos = idx + token.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String replaceGroup(String source, String regex, int groupToReplace, String replacement) {
        return StringUtils.replaceGroup(source, regex, groupToReplace, 1, replacement);
    }

    private static String replaceGroup(String source, String regex, int groupToReplace, int groupOccurrence, String replacement) {
        Matcher m = Pattern.compile(regex).matcher(source);
        for (int i = 0; i < groupOccurrence; ++i) {
            if (m.find()) continue;
            return source;
        }
        return new StringBuilder(source).replace(m.start(groupToReplace), m.end(groupToReplace), replacement).toString();
    }

    public static String collectionToCommaDelimitedString(Collection<?> collection) {
        return StringUtils.collectionToDelimitedString(collection, ", ");
    }

    public static String collectionToDelimitedString(Collection<?> collection, String delimiter) {
        if (collection == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static boolean startsAndEndsWith(String str, String prefix, String ... suffixes) {
        if (StringUtils.hasLength(prefix) && !str.startsWith(prefix)) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix) || str.length() <= (prefix + suffix).length()) continue;
            return true;
        }
        return false;
    }
}

