/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;

public class TransactionTemplate {
    private static final Log LOG = LogFactory.getLog(TransactionTemplate.class);
    private final Connection connection;
    private final boolean rollbackOnException;

    public TransactionTemplate(Connection connection) {
        this(connection, true);
    }

    public TransactionTemplate(Connection connection, boolean rollbackOnException) {
        this.connection = connection;
        this.rollbackOnException = rollbackOnException;
    }

    public <T> T execute(Callable<T> transactionCallback) {
        boolean oldAutocommit = true;
        try {
            oldAutocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            T result = transactionCallback.call();
            this.connection.commit();
            T t = result;
            return t;
        }
        catch (Exception e) {
            RuntimeException rethrow = e instanceof SQLException ? new FlywaySqlException("Unable to commit transaction", (SQLException)e) : (e instanceof RuntimeException ? (RuntimeException)e : new FlywayException(e));
            if (this.rollbackOnException) {
                try {
                    LOG.debug("Rolling back transaction...");
                    this.connection.rollback();
                    LOG.debug("Transaction rolled back");
                }
                catch (SQLException se) {
                    LOG.error("Unable to rollback transaction", se);
                }
            } else {
                try {
                    this.connection.commit();
                }
                catch (SQLException se) {
                    LOG.error("Unable to commit transaction", se);
                }
            }
            throw rethrow;
        }
        finally {
            try {
                this.connection.setAutoCommit(oldAutocommit);
            }
            catch (SQLException e) {
                LOG.error("Unable to restore autocommit to original value for connection", e);
            }
        }
    }
}

