/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.classpath.android;

import android.content.Context;
import dalvik.system.DexFile;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.android.ContextHolder;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.util.scanner.classpath.android.AndroidResource;

public class AndroidScanner
implements ResourceAndClassScanner {
    private static final Log LOG = LogFactory.getLog(AndroidScanner.class);
    private final Context context;
    private final ClassLoader classLoader;
    private final Charset encoding;

    public AndroidScanner(ClassLoader classLoader, Charset encoding) {
        this.classLoader = classLoader;
        this.encoding = encoding;
        this.context = ContextHolder.getContext();
        if (this.context == null) {
            throw new FlywayException("Unable to scan for Migrations! Context not set. Within an activity you can fix this with org.flywaydb.core.api.android.ContextHolder.setContext(this);");
        }
    }

    @Override
    public LoadableResource[] scanForResources(Location location, String prefix, String[] suffixes) throws Exception {
        ArrayList<AndroidResource> resources = new ArrayList<AndroidResource>();
        String path = location.getPath();
        for (String asset : this.context.getAssets().list(path)) {
            if (this.assetMatches(asset, prefix, suffixes)) {
                resources.add(new AndroidResource(this.context.getAssets(), path, asset, this.encoding));
                continue;
            }
            LOG.debug("Filtering out asset: " + asset);
        }
        return resources.toArray(new LoadableResource[resources.size()]);
    }

    private boolean assetMatches(String asset, String prefix, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!asset.startsWith(prefix) || !asset.endsWith(suffix) || asset.length() <= (prefix + suffix).length()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?>[] scanForClasses(Location location, Class<?> implementedInterface) throws Exception {
        String pkg = location.getPath().replace("/", ".");
        ArrayList classes = new ArrayList();
        try (DexFile dex = null;){
            dex = new DexFile(this.context.getApplicationInfo().sourceDir);
            Enumeration entries = dex.entries();
            while (entries.hasMoreElements()) {
                String className = (String)entries.nextElement();
                if (!className.startsWith(pkg)) continue;
                Class<?> clazz = this.classLoader.loadClass(className);
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    LOG.debug("Skipping abstract class: " + className);
                    continue;
                }
                if (!implementedInterface.isAssignableFrom(clazz)) continue;
                ClassUtils.instantiate(className, this.classLoader);
                classes.add(clazz);
                LOG.debug("Found class: " + className);
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

