/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.saphana.SAPHANAConnection;
import org.flywaydb.core.internal.database.saphana.SAPHANASqlScript;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class SAPHANADatabase
extends Database<SAPHANAConnection> {
    public SAPHANADatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected SAPHANAConnection getConnection(Connection connection) {
        return new SAPHANAConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    protected void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion == 1) {
            throw new FlywayEnterpriseUpgradeRequiredException("SAP", "HANA", version);
        }
        if (this.majorVersion > 2) {
            this.recommendFlywayUpgrade("SAP HANA", version);
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, boolean mixed) {
        return new SAPHANASqlScript(this.configuration, sqlScriptResource, mixed, placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "saphana";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    protected boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

