/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.ByteHolderInputStream;

public class RememberBytesInputStream
extends FilterInputStream {
    ByteHolder bh;
    boolean recording = true;
    boolean streamClosed = false;

    public RememberBytesInputStream(InputStream inputStream, ByteHolder byteHolder) {
        super(inputStream);
        this.bh = byteHolder;
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        if (!this.streamClosed) {
            n = super.read();
            if (n != -1) {
                this.bh.write(n);
            } else {
                this.streamClosed = true;
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.streamClosed) {
            if (n2 + n > byArray.length) {
                n2 = byArray.length - n;
            }
            if ((n2 = super.read(byArray, n, n2)) > 0) {
                this.bh.write(byArray, n, n2);
            } else {
                this.streamClosed = true;
            }
        } else {
            return -1;
        }
        return n2;
    }

    public long fillBuf(int n) throws IOException {
        long l = 0L;
        if (!this.streamClosed && (l = this.bh.write(this.in, n)) < (long)n) {
            this.streamClosed = true;
        }
        return l;
    }

    public int putBuf(OutputStream outputStream, int n) throws IOException {
        this.bh.startReading();
        return this.bh.read(outputStream, n);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.bh.write(this.in, l);
    }

    public InputStream getReplayStream() throws IOException {
        this.bh.startReading();
        this.recording = false;
        return new ByteHolderInputStream(this.bh);
    }

    public ByteHolder getByteHolder() throws IOException {
        return this.bh;
    }

    public void clear() throws IOException {
        this.bh.clear();
        this.recording = true;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
        this.streamClosed = false;
    }

    public boolean recording() {
        return this.recording;
    }

    @Override
    public int available() throws IOException {
        int n = this.bh.available();
        n = n > 0 ? n : -1 * n;
        return n;
    }

    public int numBytesSaved() throws IOException {
        return this.bh.numBytesSaved();
    }

    public int shiftToFront() throws IOException {
        int n = this.bh.shiftToFront();
        return n;
    }

    public String toString() {
        return "RememberBytesInputStream:  recording: " + this.recording + " " + this.bh;
    }
}

