/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.mysql.MySQLConnection;
import org.flywaydb.core.internal.database.mysql.MySQLSqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class MySQLDatabase
extends Database<MySQLConnection> {
    public MySQLDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected MySQLConnection getConnection(Connection connection) {
        return new MySQLConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    protected final void ensureSupported() {
        String productName;
        boolean isMariaDB;
        String version = this.majorVersion + "." + this.minorVersion;
        try {
            isMariaDB = this.jdbcMetaData.getDatabaseProductVersion().contains("MariaDB");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine database product version", e);
        }
        String string = productName = isMariaDB ? "MariaDB" : "MySQL";
        if (this.majorVersion < 5) {
            throw new FlywayDbUpgradeRequiredException(productName, version, "5.0");
        }
        if (this.majorVersion == 5) {
            if (this.minorVersion < 5) {
                throw new FlywayEnterpriseUpgradeRequiredException(isMariaDB ? "MariaDB" : "Oracle", productName, version);
            }
            if (this.minorVersion > 7) {
                this.recommendFlywayUpgrade(productName, version);
            }
        } else if (isMariaDB) {
            if (this.majorVersion > 10 || this.majorVersion == 10 && this.minorVersion > 2) {
                this.recommendFlywayUpgrade(productName, version);
            }
        } else if (this.majorVersion > 8 || this.majorVersion == 8 && this.minorVersion > 0) {
            this.recommendFlywayUpgrade(productName, version);
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, boolean mixed) {
        return new MySQLSqlScript(this.configuration, sqlScriptResource, mixed, placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "mysql";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((MySQLConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    protected boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

