/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleSqlScriptExecutor;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderReplacer;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusShowSqlStatement
extends AbstractSQLPlusSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusShowSqlStatement.class);
    private final String suffix;
    private final int lineSize;

    public SQLPlusShowSqlStatement(List<Line> lines, SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer) {
        super(lines);
        this.suffix = sqlPlusPlaceholderReplacer.getSuffix();
        this.lineSize = sqlPlusPlaceholderReplacer.getLineSize();
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        Results results = new Results();
        String sql = this.getSql();
        String option = sql.substring(sql.indexOf(" ") + 1).toUpperCase(Locale.ENGLISH);
        try {
            if ("CON_ID".equals(option)) {
                this.conId(jdbcTemplate);
            } else if ("EDITION".equals(option)) {
                this.edition(jdbcTemplate);
            } else if (option.startsWith("ERR")) {
                this.err(jdbcTemplate, option);
            } else if (option.startsWith("REL")) {
                this.rel(jdbcTemplate);
            } else if (option.startsWith("USER")) {
                this.user(jdbcTemplate);
            } else if (option.matches("SUF(FIX)?")) {
                LOG.info("suffix \"" + this.suffix + "\"");
            } else if (option.matches("LIN(ESIZE)?")) {
                LOG.info("linesize " + this.lineSize);
            } else if (option.matches("SERVEROUT(PUT)?")) {
                if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
                    OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
                    LOG.info("serveroutput " + (oracleSqlScriptExecutor.isServerOutput() ? "ON SIZE " + oracleSqlScriptExecutor.getServerOutputSize() + " FORMAT " + (Object)((Object)oracleSqlScriptExecutor.getServerOutputFormat()) : "OFF"));
                }
            } else {
                LOG.warn("Unknown option for SHOW: " + option);
            }
        }
        catch (SQLException e) {
            results.setException(e);
        }
        return results;
    }

    private void conId(JdbcTemplate jdbcTemplate) throws SQLException {
        LOG.info("CON_ID\n------------------------------\n" + jdbcTemplate.queryForString("SELECT CON_ID FROM V$VERSION WHERE BANNER LIKE 'Oracle Database%'", new String[0]));
    }

    private void edition(JdbcTemplate jdbcTemplate) throws SQLException {
        if (jdbcTemplate.getConnection().getMetaData().getDatabaseMajorVersion() < 11) {
            LOG.warn("SP2-0614: Server version too low for this feature\nSP2-1539: Edition requires Oracle Database 11g or later.");
        } else {
            LOG.info("EDITION\n------------------------------\n" + jdbcTemplate.queryForString("SELECT property_value FROM database_properties\nWHERE  property_name = 'DEFAULT_EDITION'", new String[0]));
        }
    }

    private void err(JdbcTemplate jdbcTemplate, String option) throws SQLException {
        List<Map<String, String>> result;
        String query = "SELECT TYPE,NAME,LINE,POSITION,TEXT FROM USER_ERRORS";
        String orderBy = " ORDER BY SEQUENCE";
        if (option.matches("(ERR|ERRORS)")) {
            result = jdbcTemplate.queryForList(query + orderBy, new Object[0]);
        } else {
            String[] typeName = StringUtils.tokenizeToStringArray(option.substring(option.indexOf(" ") + 1), " ");
            result = jdbcTemplate.queryForList(query + " WHERE TYPE=? AND NAME=?" + orderBy, typeName);
        }
        if (result.isEmpty()) {
            LOG.info("No errors.");
        } else {
            StringBuilder output = new StringBuilder("Errors for " + result.get(0).get("TYPE") + " " + result.get(0).get("NAME") + ":\n\nLINE/COL ERROR\n-------- -----------------------------------------------------------------\n");
            for (Map<String, String> row : result) {
                output.append(StringUtils.trimOrPad(row.get("LINE") + "/" + row.get("POSITION"), 8)).append(" ").append(row.get("TEXT").replace("\n", "\n         ")).append("\n");
            }
            LOG.info(output.toString().substring(0, output.length() - 1));
        }
    }

    private void rel(JdbcTemplate jdbcTemplate) throws SQLException {
        LOG.info("release " + jdbcTemplate.queryForString("SELECT VERSION FROM PRODUCT_COMPONENT_VERSION WHERE PRODUCT LIKE 'Oracle Database%'", new String[0]).replace(".", "0"));
    }

    private void user(JdbcTemplate jdbcTemplate) throws SQLException {
        LOG.info("USER is \"" + jdbcTemplate.getConnection().getMetaData().getUserName() + "\"");
    }
}

