/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.line.pro;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.line.pro.MemoryMappedLine;
import org.flywaydb.core.internal.util.IOUtils;

public class MemoryMappedLineReader
implements LineReader {
    private final MappedByteBuffer buffer;
    private final Charset encoding;
    private final byte[] newline;
    private byte[] newlineBuf;
    private int start;
    private int lineNumber;

    public MemoryMappedLineReader(File file, Charset encoding) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel channel = randomAccessFile.getChannel();
        this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        IOUtils.close(channel);
        IOUtils.close(randomAccessFile);
        this.encoding = encoding;
        this.newline = "\n".getBytes(encoding);
        this.newlineBuf = new byte[this.newline.length];
    }

    @Override
    public Line readLine() {
        while (this.buffer.position() < this.buffer.limit()) {
            byte b;
            this.shiftBytes(this.newlineBuf);
            this.newlineBuf[this.newlineBuf.length - 1] = b = this.buffer.get();
            if (!Arrays.equals(this.newline, this.newlineBuf) && this.buffer.position() != this.buffer.limit()) continue;
            ++this.lineNumber;
            MemoryMappedLine line = new MemoryMappedLine(this.lineNumber, this.buffer, this.start, this.buffer.position(), this.encoding);
            this.start = this.buffer.position();
            return line;
        }
        return null;
    }

    @Override
    public void close() {
    }

    private void shiftBytes(byte[] b) {
        if (b.length > 1) {
            System.arraycopy(b, 1, b, 0, b.length - 1 - 1);
        }
    }
}

