/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.java;

import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.internal.clazz.ClassProvider;
import org.flywaydb.core.internal.resolver.AbstractJavaMigrationResolver;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.java.JavaMigrationExecutor;

public class JavaMigrationResolver
extends AbstractJavaMigrationResolver<JavaMigration, JavaMigrationExecutor> {
    public JavaMigrationResolver(ClassProvider classProvider, Configuration configuration) {
        super(classProvider, configuration);
    }

    @Override
    protected String getMigrationTypeStr() {
        return "JDBC";
    }

    @Override
    protected Class<JavaMigration> getImplementedInterface() {
        return JavaMigration.class;
    }

    @Override
    protected JavaMigrationExecutor createExecutor(JavaMigration migration) {
        return new JavaMigrationExecutor(migration);
    }

    @Override
    protected MigrationType getMigrationType(boolean undo) {
        return undo ? MigrationType.UNDO_JDBC : MigrationType.JDBC;
    }

    @Override
    public ResolvedMigrationImpl extractMigrationInfo(JavaMigration migration) {
        ResolvedMigrationImpl resolvedMigration = new ResolvedMigrationImpl();
        resolvedMigration.setVersion(migration.getVersion());
        resolvedMigration.setDescription(migration.getDescription());
        resolvedMigration.setScript(migration.getClass().getName());
        resolvedMigration.setChecksum(migration.getChecksum());
        resolvedMigration.setType(this.getMigrationType(migration.isUndo()));
        return resolvedMigration;
    }
}

