/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.h2;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.h2.H2Connection;
import org.flywaydb.core.internal.database.h2.H2SqlStatementBuilderFactory;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.Pair;

public class H2Database
extends Database<H2Connection> {
    private int buildId;
    boolean supportsDropSchemaCascade;

    public H2Database(Configuration configuration, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, connection, originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected H2Connection getConnection(Connection connection, DryRunStatementInterceptor dryRunStatementInterceptor) {
        return new H2Connection(this.configuration, this, connection, this.originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected Pair<Integer, Integer> determineMajorAndMinorVersion() {
        Pair<Integer, Integer> majorMinor = super.determineMajorAndMinorVersion();
        try {
            this.buildId = ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForInt("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'info.BUILD_ID'", new String[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine H2 build ID", e);
        }
        return majorMinor;
    }

    @Override
    public final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion + "." + this.buildId;
        if (this.majorVersion < 1 || this.majorVersion == 1 && this.minorVersion < 2) {
            throw new FlywayDbUpgradeRequiredException("H2", version, "1.2.137");
        }
        if (this.majorVersion == 1 && this.minorVersion < 4) {
            throw new FlywayEnterpriseUpgradeRequiredException("H2", "H2", version);
        }
        if (this.majorVersion == 1 && (this.minorVersion > 4 || this.minorVersion == 4 && this.buildId > 197) || this.majorVersion > 1) {
            this.recommendFlywayUpgrade("H2", version);
        }
        this.supportsDropSchemaCascade = MigrationVersion.fromVersion(version).compareTo(MigrationVersion.fromVersion("1.4.197")) >= 0;
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer, ResourceProvider resourceProvider) {
        return new H2SqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "h2";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT USER()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

