/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.redshift.RedshiftConnection;
import org.flywaydb.core.internal.database.redshift.RedshiftSqlStatementBuilder;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.AbstractSqlStatementBuilderFactory;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class RedshiftDatabase
extends Database<RedshiftConnection> {
    public static boolean isRedshift(Connection connection) {
        try {
            return new JdbcTemplate(connection).queryForString("SELECT version()", new String[0]).contains("Redshift");
        }
        catch (Exception e) {
            return false;
        }
    }

    public RedshiftDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, connection, originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected RedshiftConnection getConnection(Connection connection, DryRunStatementInterceptor dryRunStatementInterceptor) {
        return new RedshiftConnection(this.configuration, this, connection, this.originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    public final void ensureSupported() {
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer, ResourceProvider resourceProvider) {
        return new RedshiftSqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "redshift";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((RedshiftConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return RedshiftDatabase.redshiftQuote(identifier);
    }

    static String redshiftQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }

    private static class RedshiftSqlStatementBuilderFactory
    extends AbstractSqlStatementBuilderFactory {
        public RedshiftSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer) {
            super(placeholderReplacer);
        }

        @Override
        public SqlStatementBuilder createSqlStatementBuilder() {
            return new RedshiftSqlStatementBuilder();
        }
    }
}

