/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.db2;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.db2.DB2Connection;
import org.flywaydb.core.internal.database.db2.DB2SqlStatementBuilderFactory;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;

public class DB2Database
extends Database<DB2Connection> {
    public DB2Database(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected DB2Connection getConnection(Connection connection) {
        return new DB2Connection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 9 || this.majorVersion == 9 && this.minorVersion < 7) {
            throw new FlywayDbUpgradeRequiredException("DB2", version, "9.7");
        }
        if (this.majorVersion == 9 || this.majorVersion == 10 && this.minorVersion < 5) {
            throw new FlywayEnterpriseUpgradeRequiredException("IBM", "DB2", version);
        }
        if (this.majorVersion > 11 || this.majorVersion == 11 && this.minorVersion > 1) {
            this.recommendFlywayUpgrade("DB2", version);
        }
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer) {
        return new DB2SqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE \"${schema}\".\"${table}\" (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" SMALLINT NOT NULL,\n    CONSTRAINT \"${table}_s\" CHECK (\"success\" in(0,1))\n) ORGANIZE BY ROW;\nALTER TABLE \"${schema}\".\"${table}\" ADD CONSTRAINT \"${table}_pk\" PRIMARY KEY (\"installed_rank\");\n\nCREATE INDEX \"${schema}\".\"${table}_s_idx\" ON \"${schema}\".\"${table}\" (\"success\");");
    }

    @Override
    public String getSelectStatement(Table table, int maxCachedInstalledRank) {
        return super.getSelectStatement(table, maxCachedInstalledRank) + " WITH UR";
    }

    @Override
    public String getDbName() {
        return "db2";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((DB2Connection)this.getMainConnection()).getJdbcTemplate().queryForString("select CURRENT_USER from sysibm.sysdummy1", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

