/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.internal.line.DefaultLineReader;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.resource.AbstractLoadableResource;
import org.flywaydb.core.internal.util.BomStrippingReader;
import org.flywaydb.core.internal.util.FileCopyUtils;

public class FileSystemResource
extends AbstractLoadableResource
implements Comparable<FileSystemResource> {
    private final File file;
    private final String relativePath;
    private final Charset encoding;

    public FileSystemResource(Location location, String fileNameWithPath, Charset encoding) {
        this.file = new File(new File(fileNameWithPath).getPath());
        this.relativePath = (location == null || location.getPath().isEmpty() ? this.file.getPath() : this.file.getAbsolutePath().substring(new File(location.getPath()).getAbsolutePath().length() + 1)).replace("\\", "/");
        this.encoding = encoding;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getPath();
    }

    @Override
    public String getAbsolutePathOnDisk() {
        return this.file.getAbsolutePath();
    }

    @Override
    public LineReader loadAsString() {
        try {
            return new DefaultLineReader(new BomStrippingReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath() + " (encoding: " + this.encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            FileInputStream inputStream = new FileInputStream(this.file);
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath(), e);
        }
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public int compareTo(FileSystemResource o) {
        return this.file.compareTo(o.file);
    }
}

