/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.StringUtils;

public class ErrorOverride {
    private final String state;
    private final int code;
    private final ErrorOverrideBehavior behavior;

    public ErrorOverride(String descriptor) {
        if (!descriptor.matches("^[A-Za-z0-9]{5}:-?[0-9]{1,5}:[WE]$")) {
            throw new FlywayException("Invalid error override (should look like STATE:12345:W ): " + descriptor);
        }
        String[] parts = StringUtils.tokenizeToStringArray(descriptor, ":");
        this.state = parts[0];
        this.code = Integer.parseInt(parts[1]);
        this.behavior = "W".equals(parts[2]) ? ErrorOverrideBehavior.WARNING : ErrorOverrideBehavior.ERROR;
    }

    public String getState() {
        return this.state;
    }

    public int getCode() {
        return this.code;
    }

    public ErrorOverrideBehavior getBehavior() {
        return this.behavior;
    }

    public static enum ErrorOverrideBehavior {
        WARNING,
        ERROR;

    }
}

