/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.line.pro;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.line.pro.RandomAccessLine;
import org.flywaydb.core.internal.util.IOUtils;

public class RandomAccessLineReader
implements LineReader {
    private final Charset encoding;
    private final byte[] newline;
    private byte[] newlineBuf;
    private long start;
    private int lineNumber;
    private final BufferedRandomAccessFile randomAccessFile;

    public RandomAccessLineReader(File file, Charset encoding) throws IOException {
        this.randomAccessFile = new BufferedRandomAccessFile(new RandomAccessFile(file, "r"));
        this.encoding = encoding;
        this.newline = "\n".getBytes(encoding);
        this.newlineBuf = new byte[this.newline.length];
    }

    @Override
    public Line readLine() {
        int i;
        while ((i = this.randomAccessFile.read()) != -1) {
            byte b;
            this.shiftBytes(this.newlineBuf);
            this.newlineBuf[this.newlineBuf.length - 1] = b = (byte)i;
            if (!Arrays.equals(this.newline, this.newlineBuf)) continue;
            ++this.lineNumber;
            RandomAccessLine line = new RandomAccessLine(this.lineNumber, this.randomAccessFile, this.start, this.randomAccessFile.getPos() - this.start, this.encoding);
            this.start = this.randomAccessFile.getPos();
            return line;
        }
        if (this.start < this.randomAccessFile.getPos()) {
            RandomAccessLine line = new RandomAccessLine(this.lineNumber, this.randomAccessFile, this.start, this.randomAccessFile.getPos() - this.start, this.encoding);
            this.start = this.randomAccessFile.getPos();
            return line;
        }
        return null;
    }

    @Override
    public void close() {
        IOUtils.close(this.randomAccessFile);
    }

    private void shiftBytes(byte[] b) {
        if (b.length > 1) {
            System.arraycopy(b, 1, b, 0, b.length - 1 - 1);
        }
    }

    static class BufferedRandomAccessFile
    implements Closeable {
        private final RandomAccessFile r;
        private final byte[] buffer = new byte[16384];
        private final long length;
        private long pos = 0L;
        private long bufferStart;

        private BufferedRandomAccessFile(RandomAccessFile r) throws IOException {
            this.r = r;
            this.length = r.length();
            this.bufferStart = -this.buffer.length - 1;
        }

        public long getPos() {
            return this.pos;
        }

        public int read() {
            if (this.pos >= this.length) {
                return -1;
            }
            if (this.bufferStart > this.pos || this.bufferStart + (long)this.buffer.length <= this.pos) {
                try {
                    this.r.seek(this.pos);
                    this.r.read(this.buffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.bufferStart = this.pos;
            }
            return this.buffer[(int)(this.pos++ - this.bufferStart)];
        }

        @Override
        public void close() throws IOException {
            this.r.close();
        }

        public byte read(long pos) {
            this.pos = pos;
            return (byte)this.read();
        }
    }
}

