/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.SimpleContext;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.TransactionTemplate;

public class DefaultCallbackExecutor
implements CallbackExecutor {
    private final Configuration configuration;
    private final Database database;
    private final Schema schema;
    private final Collection<Callback> callbacks;
    private MigrationInfo migrationInfo;

    public DefaultCallbackExecutor(Configuration configuration, Database database, Schema schema, Collection<Callback> callbacks) {
        this.configuration = configuration;
        this.database = database;
        this.schema = schema;
        this.callbacks = callbacks;
    }

    @Override
    public void onEvent(Event event) {
        this.execute(event, (Connection)this.database.getMainConnection());
    }

    @Override
    public void onMigrateOrUndoEvent(Event event) {
        this.execute(event, (Connection)this.database.getMigrationConnection());
    }

    @Override
    public void setMigrationInfo(MigrationInfo migrationInfo) {
        this.migrationInfo = migrationInfo;
    }

    @Override
    public void onEachMigrateOrUndoEvent(Event event) {
        SimpleContext context = new SimpleContext(this.configuration, (Connection)this.database.getMigrationConnection(), this.migrationInfo);
        for (Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            callback.handle(event, context);
        }
    }

    private void execute(final Event event, final Connection connection) {
        final SimpleContext context = new SimpleContext(this.configuration, connection, null);
        for (final Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            if (callback.canHandleInTransaction(event, context)) {
                new TransactionTemplate(connection.getJdbcConnection()).execute(new Callable<Void>(){

                    @Override
                    public Void call() {
                        DefaultCallbackExecutor.this.execute(connection, callback, event, context);
                        return null;
                    }
                });
                continue;
            }
            this.execute(connection, callback, event, context);
        }
    }

    private void execute(Connection connection, Callback callback, Event event, Context context) {
        connection.restoreOriginalState();
        connection.changeCurrentSchemaTo(this.schema);
        this.handleEvent(callback, event, context);
    }

    private void handleEvent(Callback callback, Event event, Context context) {
        try {
            callback.handle(event, context);
        }
        catch (RuntimeException e) {
            throw new FlywayException("Error while executing " + event.getId() + " callback: " + e.getMessage(), e);
        }
    }
}

