/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlite;

import java.util.regex.Pattern;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLiteSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Pattern PRAGMA_FOREIGNKEYS_REGEX = Pattern.compile("^PRAGMA FOREIGN_KEYS=.*");
    private static final Pattern CREATE_TRIGGER_REGEX = Pattern.compile("^CREATE( (TEMP|TEMPORARY))? TRIGGER.*");
    private String statementStart = "";

    SQLiteSqlStatementBuilder() {
        super(Delimiter.SEMICOLON);
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        boolean createTriggerStatement = CREATE_TRIGGER_REGEX.matcher(this.statementStart).matches();
        if (createTriggerStatement && !line.endsWith("END;")) {
            return null;
        }
        return this.defaultDelimiter;
    }

    @Override
    protected void applyStateChanges(String line) {
        super.applyStateChanges(line);
        if (!this.executeInTransaction || !this.hasNonCommentPart()) {
            return;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 8) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = StringUtils.collapseWhitespace(this.statementStart);
        }
        if (PRAGMA_FOREIGNKEYS_REGEX.matcher(this.statementStart).matches()) {
            this.executeInTransaction = false;
        }
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("X'")) {
            return token.substring(token.indexOf("'"));
        }
        return token;
    }
}

