/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.mysql.MySQLDatabase;
import org.flywaydb.core.internal.database.mysql.MySQLNamedLockTemplate;
import org.flywaydb.core.internal.database.mysql.MySQLSchema;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;

public class MySQLConnection
extends org.flywaydb.core.internal.database.base.Connection<MySQLDatabase> {
    private static final Log LOG = LogFactory.getLog(MySQLConnection.class);

    MySQLConnection(Configuration configuration, MySQLDatabase database, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, database, connection, originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected void doRestoreOriginalState() throws SQLException {
        String variablesQuery;
        List<String> userVariables;
        if ((((MySQLDatabase)this.database).isMariaDB() && ((MySQLDatabase)this.database).getVersion().isAtLeast("10.2") || !((MySQLDatabase)this.database).isMariaDB() && ((MySQLDatabase)this.database).getVersion().isAtLeast("5.7")) && !(userVariables = this.jdbcTemplate.queryForStringList(variablesQuery = ((MySQLDatabase)this.database).isMariaDB() ? "SELECT variable_name FROM information_schema.user_variables WHERE variable_value IS NOT NULL" : "SELECT variable_name FROM performance_schema.user_variables_by_thread WHERE variable_value IS NOT NULL", new String[0])).isEmpty()) {
            boolean first = true;
            StringBuilder setStatement = new StringBuilder("SET ");
            for (String userVariable : userVariables) {
                if (first) {
                    first = false;
                } else {
                    setStatement.append(",");
                }
                setStatement.append("@").append(userVariable).append("=NULL");
            }
            this.jdbcTemplate.executeStatement(setStatement.toString());
        }
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT DATABASE()", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if (StringUtils.hasLength(schema)) {
            this.jdbcTemplate.getConnection().setCatalog(schema);
        } else {
            try {
                String newDb = ((MySQLDatabase)this.database).quote(UUID.randomUUID().toString());
                this.jdbcTemplate.execute("CREATE SCHEMA " + newDb, new Object[0]);
                this.jdbcTemplate.execute("USE " + newDb, new Object[0]);
                this.jdbcTemplate.execute("DROP SCHEMA " + newDb, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Unable to restore connection to having no default schema: " + e.getMessage());
            }
        }
    }

    @Override
    protected Schema doGetCurrentSchema() throws SQLException {
        String schemaName = this.getCurrentSchemaNameOrSearchPath();
        return schemaName == null ? null : this.getSchema(schemaName);
    }

    @Override
    public Schema getSchema(String name) {
        return new MySQLSchema(this.jdbcTemplate, (MySQLDatabase)this.database, name);
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        if (((MySQLDatabase)this.database).isPxcStrict()) {
            return super.lock(table, callable);
        }
        return new MySQLNamedLockTemplate(this.jdbcTemplate, table.toString().hashCode()).execute(callable);
    }
}

