/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final Database database;
    private final SqlScript sqlScript;
    private final CallbackExecutor callbackExecutor;
    private final boolean undo;
    private final boolean batch;

    SqlMigrationExecutor(Database database, SqlScript sqlScript, CallbackExecutor callbackExecutor, boolean undo, boolean batch) {
        this.database = database;
        this.sqlScript = sqlScript;
        this.callbackExecutor = callbackExecutor;
        this.undo = undo;
        this.batch = batch;
    }

    @Override
    public void execute(Context context) {
        this.database.createSqlScriptExecutor(new JdbcTemplate(context.getConnection()), this.callbackExecutor, this.undo, this.batch).execute(this.sqlScript);
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.sqlScript.executeInTransaction();
    }
}

