/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBConnection;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSqlStatementBuilder;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.AbstractSqlStatementBuilderFactory;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class CockroachDBDatabase
extends Database<CockroachDBConnection> {
    public static boolean isCockroachDB(Connection connection) {
        try {
            return new JdbcTemplate(connection).queryForString("SELECT version()", new String[0]).contains("CockroachDB");
        }
        catch (Exception e) {
            return false;
        }
    }

    public CockroachDBDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, connection, originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected CockroachDBConnection getConnection(Connection connection, DryRunStatementInterceptor dryRunStatementInterceptor) {
        return new CockroachDBConnection(this.configuration, this, connection, this.originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("CockroachDB", "1.1");
        this.recommendFlywayUpgradeIfNecessary("CockroachDB", "2.0");
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer, ResourceProvider resourceProvider) {
        return new CockroachDBSqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    protected MigrationVersion determineVersion() {
        String version;
        try {
            version = ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT value FROM crdb_internal.node_build_info where field='Version'", new String[0]);
            if (version == null) {
                version = ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT value FROM crdb_internal.node_build_info where field='Tag'", new String[0]);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine CockroachDB version", e);
        }
        int firstDot = version.indexOf(".");
        int majorVersion = Integer.parseInt(version.substring(1, firstDot));
        String minorPatch = version.substring(firstDot + 1);
        int minorVersion = Integer.parseInt(minorPatch.substring(0, minorPatch.indexOf(".")));
        return MigrationVersion.fromVersion(majorVersion + "." + minorVersion);
    }

    @Override
    public String getDbName() {
        return "cockroachdb";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("(SELECT * FROM [SHOW SESSION_USER])", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public boolean supportsReadOnlyTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }

    private static class CockroachDBSqlStatementBuilderFactory
    extends AbstractSqlStatementBuilderFactory {
        CockroachDBSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer) {
            super(placeholderReplacer);
        }

        @Override
        public SqlStatementBuilder createSqlStatementBuilder() {
            return new CockroachDBSqlStatementBuilder();
        }
    }
}

