/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleWithPLSQLStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusAtSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusDefineSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusExecuteSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderReplacer;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPromptSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusRemarkSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusSetSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusShowSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusUndefineSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusWheneverSqlerrorSqlStatement;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class OracleSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Log LOG = LogFactory.getLog(SqlStatementBuilder.class);
    private static final Pattern KEYWORDS_BEFORE_STRING_LITERAL_REGEX = Pattern.compile("^(N|DATE|IF|ELSIF|SELECT|IMMEDIATE|RETURN|IS)('.*)");
    private static final Pattern KEYWORDS_AFTER_STRING_LITERAL_REGEX = Pattern.compile("(.*')(USING|THEN|FROM|AND|OR|AS)(?!.)");
    private static final String SUPPORTED_WHENEVER_SQLERROR_OPTIONS = "CONTINUE|EXIT FAILURE";
    private static final String UNSUPPORTED_SQLPLUS_COMMANDS = "ACC(EPT)?|A(PPEND)?|ARCHIVE|ATTR(IBUTE)?|BRE(AK)?|BTI(TLE)?|C(HANGE)?|CL(EAR)?|COL(UMN)?|COMP(UTE)?|CONN(ECT)?|COPY|DEL|DESC(RIBE)?|DISC(ONNECT)?|ED(IT)?|EXIT|GET|HELP|HIST(ORY)?|HO(ST)?|I(NPUT)?|L(IST)?|PASSW(ORD)?|PAU(SE)?|PRINT|QUIT|RECOVER|REPF(OOTER)?|REPH(EADER)?|R(UN)?|SAV(E)?|SHUTDOWN|SPO(OL)?|STARTUP|STORE|TIMI(NG)?|TTI(TLE)?|VAR(IABLE)?|WHENEVER OSERROR|WHENEVER SQLERROR(?! (CONTINUE|EXIT FAILURE))|XQUERY";
    private static final Pattern UNSUPPORTED_SQLPLUS_COMMANDS_REGEX = OracleSqlStatementBuilder.toRegex("ACC(EPT)?|A(PPEND)?|ARCHIVE|ATTR(IBUTE)?|BRE(AK)?|BTI(TLE)?|C(HANGE)?|CL(EAR)?|COL(UMN)?|COMP(UTE)?|CONN(ECT)?|COPY|DEL|DESC(RIBE)?|DISC(ONNECT)?|ED(IT)?|EXIT|GET|HELP|HIST(ORY)?|HO(ST)?|I(NPUT)?|L(IST)?|PASSW(ORD)?|PAU(SE)?|PRINT|QUIT|RECOVER|REPF(OOTER)?|REPH(EADER)?|R(UN)?|SAV(E)?|SHUTDOWN|SPO(OL)?|STARTUP|STORE|TIMI(NG)?|TTI(TLE)?|VAR(IABLE)?|WHENEVER OSERROR|WHENEVER SQLERROR(?! (CONTINUE|EXIT FAILURE))|XQUERY");
    private static final String AT_COMMANDS = "@";
    private static final Pattern AT_REGEX = OracleSqlStatementBuilder.toRegexNoSpace("@");
    private static final String DEFINE_COMMANDS = "DEF(INE)?";
    private static final Pattern DEFINE_REGEX = OracleSqlStatementBuilder.toRegex("DEF(INE)?");
    private static final String EXECUTE_COMMANDS = "EXEC(UTE)?";
    private static final Pattern EXECUTE_REGEX = OracleSqlStatementBuilder.toRegex("EXEC(UTE)?");
    private static final Pattern PROMPT_REGEX = OracleSqlStatementBuilder.toRegex("PRO(MPT)?");
    private static final String REMARK_COMMANDS = "REM(ARK)?";
    private static final Pattern REMARK_REGEX = OracleSqlStatementBuilder.toRegex("REM(ARK)?");
    private static final String SET_COMMANDS = "SET";
    private static final Pattern SET_REGEX = OracleSqlStatementBuilder.toRegexNoSpace("SET");
    private static final String SHOW_COMMANDS = "SHO(W)?";
    private static final Pattern SHOW_REGEX = OracleSqlStatementBuilder.toRegexNoSpace("SHO(W)?");
    private static final String START_COMMANDS = "STA(RT)?";
    private static final Pattern START_REGEX = OracleSqlStatementBuilder.toRegex("STA(RT)?");
    private static final String UNDEFINE_COMMANDS = "UNDEF(INE)?";
    private static final Pattern UNDEFINE_REGEX = OracleSqlStatementBuilder.toRegex("UNDEF(INE)?");
    private static final String WHENEVER_SQLERROR_COMMANDS = "WHENEVER SQLERROR (CONTINUE|EXIT FAILURE)";
    private static final Pattern WHENEVER_SQLERROR_REGEX = OracleSqlStatementBuilder.toRegexNoSpace("WHENEVER SQLERROR (CONTINUE|EXIT FAILURE)");
    private static final Pattern SQLPLUS_REGEX = Pattern.compile(OracleSqlStatementBuilder.toRegexPattern("ACC(EPT)?|A(PPEND)?|ARCHIVE|ATTR(IBUTE)?|BRE(AK)?|BTI(TLE)?|C(HANGE)?|CL(EAR)?|COL(UMN)?|COMP(UTE)?|CONN(ECT)?|COPY|DEL|DESC(RIBE)?|DISC(ONNECT)?|ED(IT)?|EXIT|GET|HELP|HIST(ORY)?|HO(ST)?|I(NPUT)?|L(IST)?|PASSW(ORD)?|PAU(SE)?|PRINT|QUIT|RECOVER|REPF(OOTER)?|REPH(EADER)?|R(UN)?|SAV(E)?|SHUTDOWN|SPO(OL)?|STARTUP|STORE|TIMI(NG)?|TTI(TLE)?|VAR(IABLE)?|WHENEVER OSERROR|WHENEVER SQLERROR(?! (CONTINUE|EXIT FAILURE))|XQUERY", "DEF(INE)?", "EXEC(UTE)?", "PRO(MPT)?", "REM(ARK)?", "SET", "SHO(W)?", "STA(RT)?", "UNDEF(INE)?", "WHENEVER SQLERROR (CONTINUE|EXIT FAILURE)") + "|" + OracleSqlStatementBuilder.toRegexPatternNoSpace("@"));
    private static final Pattern DECLARE_BEGIN_REGEX = OracleSqlStatementBuilder.toRegex("DECLARE|BEGIN");
    private static final Pattern PLSQL_VIEW_REGEX = Pattern.compile("^CREATE(\\s+OR\\s+REPLACE)?(\\s+(NON)?EDITIONABLE)?\\s+(VIEW)\\s+.*\\s+AS\\s+WITH.*");
    private static final Pattern PLSQL_REGEX = Pattern.compile("^CREATE(\\s+OR\\s+REPLACE)?(\\s+(NON)?EDITIONABLE)?\\s+(FUNCTION|PROCEDURE|PACKAGE|TYPE|TRIGGER).*");
    private static final Pattern JAVA_REGEX = Pattern.compile("^CREATE(\\s+OR\\s+REPLACE)?(\\s+AND\\s+(RESOLVE|COMPILE))?(\\s+NOFORCE)?\\s+JAVA\\s+(SOURCE|RESOURCE|CLASS).*");
    static final Delimiter PLSQL_DELIMITER = new Delimiter("/", true);
    private final boolean oracleSqlplus;
    private final SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer;
    private final ResourceProvider resourceProvider;
    private final SqlStatementBuilderFactory sqlStatementBuilderFactory;
    private String statementStart = "";

    private static Pattern toRegex(String ... commands) {
        return Pattern.compile(OracleSqlStatementBuilder.toRegexPattern(commands));
    }

    private static String toRegexPattern(String ... commands) {
        return "^(" + StringUtils.arrayToDelimitedString("|", commands) + ")(\\s.*)?";
    }

    private static Pattern toRegexNoSpace(String ... commands) {
        return Pattern.compile(OracleSqlStatementBuilder.toRegexPatternNoSpace(commands));
    }

    private static String toRegexPatternNoSpace(String ... commands) {
        return "^(" + StringUtils.arrayToDelimitedString("|", commands) + ").*";
    }

    public OracleSqlStatementBuilder(boolean oracleSqlplus, SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer, ResourceProvider resourceProvider, SqlStatementBuilderFactory sqlStatementBuilderFactory) {
        super(Delimiter.SEMICOLON);
        this.oracleSqlplus = oracleSqlplus;
        this.sqlPlusPlaceholderReplacer = sqlPlusPlaceholderReplacer;
        this.resourceProvider = resourceProvider;
        this.sqlStatementBuilderFactory = sqlStatementBuilderFactory;
    }

    @Override
    public SqlStatement getSqlStatement() {
        if (this.oracleSqlplus) {
            if (AT_REGEX.matcher(this.statementStart).matches() || START_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusAtSqlStatement(this.lines, this.sqlPlusPlaceholderReplacer, this.sqlStatementBuilderFactory, this.resourceProvider);
            }
            if (DEFINE_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusDefineSqlStatement(this.lines, this.sqlPlusPlaceholderReplacer);
            }
            if (EXECUTE_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusExecuteSqlStatement(this.lines);
            }
            if (PROMPT_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusPromptSqlStatement(this.lines);
            }
            if (REMARK_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusRemarkSqlStatement(this.lines);
            }
            if (SET_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusSetSqlStatement(this.lines, this.sqlPlusPlaceholderReplacer);
            }
            if (SHOW_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusShowSqlStatement(this.lines, this.sqlPlusPlaceholderReplacer);
            }
            if (UNDEFINE_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusUndefineSqlStatement(this.lines, this.sqlPlusPlaceholderReplacer);
            }
            if (WHENEVER_SQLERROR_REGEX.matcher(this.statementStart).matches()) {
                return new SQLPlusWheneverSqlerrorSqlStatement(this.lines);
            }
        }
        if (PLSQL_VIEW_REGEX.matcher(this.statementStart).matches()) {
            return new OracleWithPLSQLStatement(this.lines);
        }
        return super.getSqlStatement();
    }

    @Override
    public boolean isTerminated() {
        if (this.oracleSqlplus) {
            String lastLine = ((Line)this.lines.get(this.lines.size() - 1)).getLine();
            return SQLPLUS_REGEX.matcher(this.statementStart).matches() && !lastLine.trim().endsWith("-") || super.isTerminated();
        }
        return super.isTerminated();
    }

    @Override
    protected void applyStateChanges(String line) {
        super.applyStateChanges(line);
        if (this.hasNonCommentPart() && StringUtils.countOccurrencesOf(this.statementStart, " ") < 8) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = StringUtils.collapseWhitespace(this.statementStart);
        }
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (DECLARE_BEGIN_REGEX.matcher(line).matches()) {
            return PLSQL_DELIMITER;
        }
        if (PLSQL_REGEX.matcher(this.statementStart).matches() || JAVA_REGEX.matcher(this.statementStart).matches() || PLSQL_VIEW_REGEX.matcher(this.statementStart).matches()) {
            return PLSQL_DELIMITER;
        }
        return delimiter;
    }

    @Override
    protected String cleanToken(String token) {
        Matcher afterMatcher;
        if (token.startsWith("'") && token.endsWith("'")) {
            return token;
        }
        Matcher beforeMatcher = KEYWORDS_BEFORE_STRING_LITERAL_REGEX.matcher(token);
        if (beforeMatcher.find()) {
            token = beforeMatcher.group(2);
        }
        if ((afterMatcher = KEYWORDS_AFTER_STRING_LITERAL_REGEX.matcher(token)).find()) {
            token = afterMatcher.group(1);
        }
        return token;
    }

    @Override
    protected String simplifyLine(String line) {
        String simplifiedQQuotes = StringUtils.replaceAll(StringUtils.replaceAll(line, "q'(", "q'["), ")'", "]'");
        return super.simplifyLine(simplifiedQQuotes);
    }

    @Override
    protected String extractAlternateOpenQuote(String token) {
        if (token.startsWith("Q'") && token.length() >= 3) {
            return token.substring(0, 3);
        }
        return null;
    }

    @Override
    protected String computeAlternateCloseQuote(String openQuote) {
        char specialChar = openQuote.charAt(2);
        switch (specialChar) {
            case '[': {
                return "]'";
            }
            case '(': {
                return ")'";
            }
            case '{': {
                return "}'";
            }
            case '<': {
                return ">'";
            }
        }
        return specialChar + "'";
    }

    @Override
    public boolean canDiscard() {
        return super.canDiscard() || this.isUnsupportedSqlPlusStatement() || this.statementStart.equals("/ ");
    }

    boolean isUnsupportedSqlPlusStatement() {
        if (UNSUPPORTED_SQLPLUS_COMMANDS_REGEX.matcher(this.statementStart).matches()) {
            LOG.warn("Ignoring unsupported SQL*Plus statement: " + StringUtils.collectionToDelimitedString(this.lines, "\n"));
            return true;
        }
        return false;
    }
}

