/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.sqlserver.SQLServerConnection;
import org.flywaydb.core.internal.database.sqlserver.SQLServerSqlStatementBuilderFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLServerDatabase
extends Database<SQLServerConnection> {
    private final boolean azure;

    public SQLServerDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, connection, originalAutoCommit, dryRunStatementInterceptor);
        try {
            this.azure = "SQL Azure".equals(((SQLServerConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT CAST(SERVERPROPERTY('edition') AS VARCHAR)", new String[0]));
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine database edition", e);
        }
    }

    @Override
    protected SQLServerConnection getConnection(Connection connection, DryRunStatementInterceptor dryRunStatementInterceptor) {
        return new SQLServerConnection(this.configuration, this, connection, this.originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("SQL Server", "10.0");
        this.ensureDatabaseIsCompatibleWithFlywayEdition("Microsoft", "SQL Server", "12");
        this.recommendFlywayUpgradeIfNecessary("SQL Server", "14.0");
    }

    @Override
    protected String computeVersionDisplayName(MigrationVersion version) {
        if (this.getVersion().isAtLeast("8")) {
            if ("8".equals(this.getVersion().getMajorAsString())) {
                return "2000";
            }
            if ("9".equals(this.getVersion().getMajorAsString())) {
                return "2005";
            }
            if ("10".equals(this.getVersion().getMajorAsString())) {
                if ("0".equals(this.getVersion().getMinorAsString())) {
                    return "2008";
                }
                return "2008 R2";
            }
            if ("11".equals(this.getVersion().getMajorAsString())) {
                return "2012";
            }
            if ("12".equals(this.getVersion().getMajorAsString())) {
                return "2014";
            }
            if ("13".equals(this.getVersion().getMajorAsString())) {
                return "2016";
            }
            if ("14".equals(this.getVersion().getMajorAsString())) {
                return "2017";
            }
        }
        return super.computeVersionDisplayName(version);
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer, ResourceProvider resourceProvider) {
        return new SQLServerSqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "sqlserver";
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return new Delimiter("GO", true);
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((SQLServerConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUSER_SNAME()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll(identifier, "]", "]]");
    }

    @Override
    public String doQuote(String identifier) {
        return "[" + this.escapeIdentifier(identifier) + "]";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE ${table_quoted} (\n    [installed_rank] INT NOT NULL,\n    [version] NVARCHAR(50),\n    [description] NVARCHAR(200),\n    [type] NVARCHAR(20) NOT NULL,\n    [script] NVARCHAR(1000) NOT NULL,\n    [checksum] INT,\n    [installed_by] NVARCHAR(100) NOT NULL,\n    [installed_on] DATETIME NOT NULL DEFAULT GETDATE(),\n    [execution_time] INT NOT NULL,\n    [success] BIT NOT NULL\n);\nALTER TABLE ${table_quoted} ADD CONSTRAINT [${table}_pk] PRIMARY KEY ([installed_rank]);\n\nCREATE INDEX [${table}_s_idx] ON ${table_quoted} ([success]);\nGO\n");
    }

    boolean isAzure() {
        return this.azure;
    }
}

