/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.jdbc.DatabaseType;
import org.flywaydb.core.internal.jdbc.ErrorImpl;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.RowMapper;
import org.flywaydb.core.internal.jdbc.WarningImpl;

public class JdbcTemplate {
    private final Connection connection;
    private final int nullType;

    public JdbcTemplate(Connection connection) {
        this.connection = connection;
        this.nullType = DatabaseType.fromJdbcConnection(connection).getNullType();
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> queryForList(String query, Object ... params) throws SQLException {
        ArrayList<Map<String, String>> result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            result = new ArrayList<Map<String, String>>();
            while (resultSet.next()) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    rowMap.put(resultSet.getMetaData().getColumnLabel(i), resultSet.getString(i));
                }
                result.add(rowMap);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryForStringList(String query, String ... params) throws SQLException {
        ArrayList<String> result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            result = new ArrayList<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryForInt(String query, String ... params) throws SQLException {
        int result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            resultSet.next();
            result = resultSet.getInt(1);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryForBoolean(String query, String ... params) throws SQLException {
        boolean result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            resultSet.next();
            result = resultSet.getBoolean(1);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryForString(String query, String ... params) throws SQLException {
        String result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            result = null;
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(sql, params);
            statement.execute();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results executeStatement(String sql) {
        Results results = new Results();
        Statement statement = null;
        try {
            boolean hasResults;
            statement = this.connection.createStatement();
            statement.setEscapeProcessing(false);
            try {
                hasResults = statement.execute(sql);
            }
            finally {
                this.extractWarnings(results, statement);
            }
            this.extractResults(results, statement, hasResults);
        }
        catch (SQLException e) {
            this.extractErrors(results, e);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
        return results;
    }

    private void extractWarnings(Results results, Statement statement) throws SQLException {
        for (SQLWarning warning = statement.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            results.addWarning(new WarningImpl(warning.getErrorCode(), warning.getSQLState(), warning.getMessage()));
        }
    }

    public void extractErrors(Results results, SQLException e) {
        for (SQLException sqle = e; sqle != null; sqle = sqle.getNextException()) {
            results.addError(new ErrorImpl(sqle.getErrorCode(), sqle.getSQLState(), sqle.getMessage()));
        }
        results.setException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractResults(Results results, Statement statement, boolean hasResults) throws SQLException {
        int updateCount = -1;
        while (hasResults || (updateCount = statement.getUpdateCount()) != -1) {
            ArrayList<String> columns = null;
            ArrayList data = null;
            if (hasResults) {
                try (ResultSet resultSet = statement.getResultSet();){
                    columns = new ArrayList<String>();
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    int columnCount = metadata.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        columns.add(metadata.getColumnName(i));
                    }
                    data = new ArrayList();
                    while (resultSet.next()) {
                        ArrayList<String> row = new ArrayList<String>();
                        for (int i = 1; i <= columnCount; ++i) {
                            row.add(resultSet.getString(i));
                        }
                        data.add(row);
                    }
                }
            }
            results.addResult(new Result(updateCount, columns, data));
            hasResults = statement.getMoreResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(sql, params);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeStatement(statement);
    }

    private PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                statement.setNull(i + 1, this.nullType);
                continue;
            }
            if (params[i] instanceof Integer) {
                statement.setInt(i + 1, (Integer)params[i]);
                continue;
            }
            if (params[i] instanceof Boolean) {
                statement.setBoolean(i + 1, (Boolean)params[i]);
                continue;
            }
            statement.setString(i + 1, params[i].toString());
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String query, RowMapper<T> rowMapper) throws SQLException {
        ArrayList<T> results;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(query);
            results = new ArrayList<T>();
            while (resultSet.next()) {
                results.add(rowMapper.mapRow(resultSet));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results executeBatch(List<String> sqlBatch) {
        Results results = new Results();
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            for (String sql : sqlBatch) {
                statement.addBatch(sql);
            }
            try {
                for (Object intResult : (Object)statement.executeBatch()) {
                    results.addResult(new Result((long)intResult, null, null));
                }
            }
            catch (BatchUpdateException e) {
                for (int intResult : e.getUpdateCounts()) {
                    results.addResult(new Result(intResult, null, null));
                }
                this.extractErrors(results, e);
            }
            finally {
                this.extractWarnings(results, statement);
            }
        }
        catch (SQLException e) {
            this.extractErrors(results, e);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
        return results;
    }
}

