/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.saphana.SAPHANAConnection;
import org.flywaydb.core.internal.database.saphana.SAPHANAStatementBuilderFactory;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;

public class SAPHANADatabase
extends Database<SAPHANAConnection> {
    public SAPHANADatabase(Configuration configuration, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, connection, originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected SAPHANAConnection getConnection(Connection connection, DryRunStatementInterceptor dryRunStatementInterceptor) {
        return new SAPHANAConnection(this.configuration, this, connection, this.originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    public void ensureSupported() {
        this.recommendFlywayUpgradeIfNecessaryForMajorVersion("SAP HANA", "2");
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer, ResourceProvider resourceProvider) {
        return new SAPHANAStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "saphana";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

