--
-- Copyright 2010-2018 Boxfuse GmbH
--
--
-- Boxfuse GmbH grants the Licensee a non-exclusive,
-- timely limited and non-transferable license
-- to install and use the Software under the terms of
-- the Flyway License and Maintenance Agreement.
--
--
-- This software is distributed with a LIMITED WARRANTY.
-- See the Flyway License and Maintenance Agreement
-- for more details:
-- https://flywaydb.org/licenses/flyway-pro.txt
--

CREATE TABLE "${schema}"."${table}" (
    "installed_rank" INT NOT NULL SORTKEY,
    "version" VARCHAR(50),
    "description" VARCHAR(200) NOT NULL,
    "type" VARCHAR(20) NOT NULL,
    "script" VARCHAR(1000) NOT NULL,
    "checksum" INTEGER,
    "installed_by" VARCHAR(100) NOT NULL,
    "installed_on" TIMESTAMP NOT NULL DEFAULT getdate(),
    "execution_time" INTEGER NOT NULL,
    "success" BOOLEAN NOT NULL
);
ALTER TABLE "${schema}"."${table}" ADD CONSTRAINT "${table}_pk" PRIMARY KEY ("installed_rank");
