/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.dao;

import java.sql.ResultSet;
import org.mariadb.jdbc.internal.com.read.dao.CmdInformation;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.protocol.Protocol;

public class CmdInformationSingle
implements CmdInformation {
    private final long insertId;
    private final int autoIncrement;
    private long updateCount;

    public CmdInformationSingle(long insertId, long updateCount, int autoIncrement) {
        this.insertId = insertId;
        this.updateCount = updateCount;
        this.autoIncrement = autoIncrement;
    }

    @Override
    public int[] getUpdateCounts() {
        return new int[]{(int)this.updateCount};
    }

    @Override
    public int[] getServerUpdateCounts() {
        return new int[]{(int)this.updateCount};
    }

    @Override
    public long[] getLargeUpdateCounts() {
        return new long[]{this.updateCount};
    }

    @Override
    public int getUpdateCount() {
        return (int)this.updateCount;
    }

    @Override
    public long getLargeUpdateCount() {
        return this.updateCount;
    }

    @Override
    public void addErrorStat() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void addResultSetStat() {
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        if (this.insertId == 0L) {
            return SelectResultSet.createEmptyResultSet();
        }
        if (this.updateCount > 1L) {
            long[] insertIds = new long[(int)this.updateCount];
            int i = 0;
            while ((long)i < this.updateCount) {
                insertIds[i] = this.insertId + (long)(i * this.autoIncrement);
                ++i;
            }
            return SelectResultSet.createGeneratedData(insertIds, protocol, true);
        }
        return SelectResultSet.createGeneratedData(new long[]{this.insertId}, protocol, true);
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        return this.getGeneratedKeys(protocol);
    }

    @Override
    public int getCurrentStatNumber() {
        return 1;
    }

    @Override
    public boolean moreResults() {
        this.updateCount = -1L;
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return this.updateCount != -1L;
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId) {
    }

    @Override
    public void setRewrite(boolean rewritten) {
    }
}

