/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.input;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.io.LruTraceCache;
import org.mariadb.jdbc.internal.io.TraceObject;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.input.ReadAheadBufferedStream;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.Utils;

public class StandardPacketInputStream
implements PacketInputStream {
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private static final Logger logger = LoggerFactory.getLogger(StandardPacketInputStream.class);
    private final byte[] header = new byte[4];
    private final byte[] reusableArray = new byte[1024];
    private final InputStream inputStream;
    private final int maxQuerySizeToLog;
    private int packetSeq;
    private int lastPacketLength;
    private String serverThreadLog = "";
    private LruTraceCache traceCache = null;

    public StandardPacketInputStream(InputStream in, Options options) {
        this.inputStream = options.useReadAheadInput ? new ReadAheadBufferedStream(in) : new BufferedInputStream(in, 16384);
        this.maxQuerySizeToLog = options.maxQuerySizeToLog;
    }

    public static byte[] create(byte[] value) {
        if (value == null) {
            return new byte[]{-5};
        }
        int length = value.length;
        if (length < 251) {
            byte[] buf = new byte[length + 1];
            buf[0] = (byte)length;
            System.arraycopy(value, 0, buf, 1, length);
            return buf;
        }
        if (length < 65536) {
            byte[] buf = new byte[length + 3];
            buf[0] = -4;
            buf[1] = (byte)length;
            buf[2] = (byte)(length >>> 8);
            System.arraycopy(value, 0, buf, 3, length);
            return buf;
        }
        if (length < 0x1000000) {
            byte[] buf = new byte[length + 4];
            buf[0] = -3;
            buf[1] = (byte)length;
            buf[2] = (byte)(length >>> 8);
            buf[3] = (byte)(length >>> 16);
            System.arraycopy(value, 0, buf, 4, length);
            return buf;
        }
        byte[] buf = new byte[length + 9];
        buf[0] = -2;
        buf[1] = (byte)length;
        buf[2] = (byte)(length >>> 8);
        buf[3] = (byte)(length >>> 16);
        buf[4] = (byte)(length >>> 24);
        System.arraycopy(value, 0, buf, 9, length);
        return buf;
    }

    public static byte[] create(byte[][] rowDatas, ColumnType[] columnTypes) {
        int totalLength = 0;
        for (byte[] rowData : rowDatas) {
            if (rowData == null) {
                ++totalLength;
                continue;
            }
            int length = rowData.length;
            if (length < 251) {
                totalLength += length + 1;
                continue;
            }
            if (length < 65536) {
                totalLength += length + 3;
                continue;
            }
            if (length < 0x1000000) {
                totalLength += length + 4;
                continue;
            }
            totalLength += length + 9;
        }
        byte[] buf = new byte[totalLength];
        int pos = 0;
        for (byte[] arr : rowDatas) {
            if (arr == null) {
                buf[pos++] = -5;
                continue;
            }
            int length = arr.length;
            if (length < 251) {
                buf[pos++] = (byte)length;
            } else if (length < 65536) {
                buf[pos++] = -4;
                buf[pos++] = (byte)length;
                buf[pos++] = (byte)(length >>> 8);
            } else if (length < 0x1000000) {
                buf[pos++] = -3;
                buf[pos++] = (byte)length;
                buf[pos++] = (byte)(length >>> 8);
                buf[pos++] = (byte)(length >>> 16);
            } else {
                buf[pos++] = -2;
                buf[pos++] = (byte)length;
                buf[pos++] = (byte)(length >>> 8);
                buf[pos++] = (byte)(length >>> 16);
                buf[pos++] = (byte)(length >>> 24);
                pos += 4;
            }
            System.arraycopy(arr, 0, buf, pos, length);
            pos += length;
        }
        return buf;
    }

    @Override
    public Buffer getPacket(boolean reUsable) throws IOException {
        return new Buffer(this.getPacketArray(reUsable), this.lastPacketLength);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public byte[] getPacketArray(boolean reUsable) throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        this.lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        this.packetSeq = this.header[3];
        byte[] rawBytes = reUsable && this.lastPacketLength < 1024 ? this.reusableArray : new byte[this.lastPacketLength];
        remaining = this.lastPacketLength;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (this.lastPacketLength - remaining) + " bytes from " + this.lastPacketLength + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (this.traceCache != null) {
            this.traceCache.put(new TraceObject(false, 0, Arrays.copyOfRange(this.header, 0, 4), Arrays.copyOfRange(rawBytes, 0, off > 1000 ? 1000 : off)));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("read: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 4, 0, this.lastPacketLength, (byte[][])new byte[][]{this.header, rawBytes}));
        }
        if (this.lastPacketLength == 0xFFFFFF) {
            int packetLength;
            do {
                int count3;
                int count4;
                remaining = 4;
                off = 0;
                do {
                    if ((count4 = this.inputStream.read(this.header, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
                    }
                    off += count4;
                } while ((remaining -= count4) > 0);
                packetLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
                this.packetSeq = this.header[3];
                int currentBufferLength = rawBytes.length;
                byte[] newRawBytes = new byte[currentBufferLength + packetLength];
                System.arraycopy(rawBytes, 0, newRawBytes, 0, currentBufferLength);
                rawBytes = newRawBytes;
                remaining = packetLength;
                off = currentBufferLength;
                do {
                    if ((count3 = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength);
                    }
                    off += count3;
                } while ((remaining -= count3) > 0);
                if (this.traceCache != null) {
                    this.traceCache.put(new TraceObject(false, 0, Arrays.copyOfRange(this.header, 0, 4), Arrays.copyOfRange(rawBytes, 0, off > 1000 ? 1000 : off)));
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("read: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 4, currentBufferLength, packetLength, (byte[][])new byte[][]{this.header, rawBytes}));
                }
                this.lastPacketLength += packetLength;
            } while (packetLength == 0xFFFFFF);
        }
        return rawBytes;
    }

    @Override
    public int getLastPacketSeq() {
        return this.packetSeq;
    }

    @Override
    public int getCompressLastPacketSeq() {
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(long serverThreadId, Boolean isMaster) {
        this.serverThreadLog = "conn=" + serverThreadId + (isMaster != null ? "(" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache traceCache) {
        this.traceCache = traceCache;
    }
}

