/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.snowflake;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.snowflake.SnowflakeConnection;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;

public class SnowflakeDatabase
extends Database<SnowflakeConnection> {
    public SnowflakeDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
    }

    @Override
    protected SnowflakeConnection doGetConnection(Connection connection) {
        return new SnowflakeConnection(this, connection);
    }

    @Override
    public void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("3.0");
        this.recommendFlywayUpgradeIfNecessaryForMajorVersion("4.2");
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n" + this.quote("installed_rank") + " NUMBER(38,0) NOT NULL,\n" + this.quote("version") + " VARCHAR(50),\n" + this.quote("description") + " VARCHAR(200),\n" + this.quote("type") + " VARCHAR(20) NOT NULL,\n" + this.quote("script") + " VARCHAR(1000) NOT NULL,\n" + this.quote("checksum") + " NUMBER(38,0),\n" + this.quote("installed_by") + " VARCHAR(100) NOT NULL,\n" + this.quote("installed_on") + " TIMESTAMP_LTZ(9) NOT NULL DEFAULT CURRENT_TIMESTAMP(),\n" + this.quote("execution_time") + " NUMBER(38,0) NOT NULL,\n" + this.quote("success") + " BOOLEAN NOT NULL,\nprimary key (" + this.quote("installed_rank") + "));\n" + (baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    @Override
    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + table + " WHERE " + this.quote("installed_rank") + " > ? ORDER BY " + this.quote("installed_rank");
    }

    @Override
    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote("installed_rank") + ", " + this.quote("version") + ", " + this.quote("description") + ", " + this.quote("type") + ", " + this.quote("script") + ", " + this.quote("checksum") + ", " + this.quote("installed_by") + ", " + this.quote("execution_time") + ", " + this.quote("success") + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "true";
    }

    @Override
    public String getBooleanFalse() {
        return "false";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

