/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusDefineParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOGGER = LogFactory.getLog(SQLPlusDefineParsedSqlStatement.class);
    private final Map<String, String> varsToPrint = new TreeMap<String, String>();

    public SQLPlusDefineParsedSqlStatement(int pos, int line, int col, String sql, List<Token> tokens, SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider) {
        super(pos, line, col, sql);
        String noDefine;
        int idx;
        String noTrailingComment = this.getSql();
        Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.getType() == TokenType.COMMENT) {
            noTrailingComment = noTrailingComment.substring(0, lastToken.getCol() - 1);
        }
        if ((idx = (noDefine = noTrailingComment.replaceFirst("(?i)(DEF(INE)?)[ ]?", "")).indexOf("=")) > 0) {
            String varName = noDefine.substring(0, idx).trim();
            String varValue = noDefine.substring(idx + 1).trim();
            if (varValue.startsWith("'") && varValue.endsWith("'")) {
                varValue = varValue.substring(1, varValue.length() - 1);
            }
            sqlPlusPlaceholderProvider.define(varName, varValue);
        } else {
            String varName = noDefine.trim();
            if (StringUtils.hasLength(varName)) {
                this.varsToPrint.put(varName, sqlPlusPlaceholderProvider.getPlaceholderReplacements().get(varName));
            } else {
                this.varsToPrint.putAll(sqlPlusPlaceholderProvider.getPlaceholderReplacements());
            }
        }
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        for (Map.Entry<String, String> entry : this.varsToPrint.entrySet()) {
            if (entry.getValue() == null) {
                LOGGER.warn("SP2-0135: symbol " + entry.getKey() + " is UNDEFINED");
                continue;
            }
            LOGGER.info("DEFINE " + entry.getKey() + " = \"" + entry.getValue() + "\" (CHAR)");
        }
        return new Results();
    }
}

