/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.teams;

import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class DryRunCallback
implements Callback {
    private final StatementInterceptor statementInterceptor;

    public DryRunCallback(StatementInterceptor statementInterceptor) {
        this.statementInterceptor = statementInterceptor;
    }

    @Override
    public boolean supports(Event event, Context context) {
        switch (event) {
            case BEFORE_CLEAN: 
            case BEFORE_MIGRATE: 
            case BEFORE_EACH_MIGRATE: 
            case BEFORE_UNDO: 
            case BEFORE_EACH_UNDO: 
            case BEFORE_VALIDATE: 
            case BEFORE_BASELINE: 
            case BEFORE_REPAIR: 
            case BEFORE_INFO: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canHandleInTransaction(Event event, Context context) {
        return true;
    }

    @Override
    public void handle(Event event, Context context) {
        MigrationInfo info = context.getMigrationInfo();
        switch (event) {
            case BEFORE_CLEAN: {
                this.statementInterceptor.interceptCommand("clean");
                return;
            }
            case BEFORE_MIGRATE: {
                this.statementInterceptor.interceptCommand("migrate");
                return;
            }
            case BEFORE_EACH_MIGRATE: {
                this.statementInterceptor.interceptCommand("migrate -> " + (info.getVersion() == null ? info.getDescription() + " [repeatable]" : "v" + info.getVersion()));
                return;
            }
            case BEFORE_UNDO: {
                this.statementInterceptor.interceptCommand("undo");
                return;
            }
            case BEFORE_EACH_UNDO: {
                this.statementInterceptor.interceptCommand("undo -> v" + info.getVersion());
                return;
            }
            case BEFORE_VALIDATE: {
                this.statementInterceptor.interceptCommand("validate");
                return;
            }
            case BEFORE_BASELINE: {
                this.statementInterceptor.interceptCommand("baseline");
                return;
            }
            case BEFORE_REPAIR: {
                this.statementInterceptor.interceptCommand("repair");
                return;
            }
            case BEFORE_INFO: {
                this.statementInterceptor.interceptCommand("info");
                return;
            }
        }
    }

    @Override
    public String getCallbackName() {
        return "DryRun";
    }
}

