/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.StandardOpenOption;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.filesystem.teams.EncodingDetector;
import org.flywaydb.core.internal.resource.filesystem.teams.FlywayEncodingDetectionException;
import org.flywaydb.core.internal.util.BomStrippingReader;

public class FileSystemResource
extends LoadableResource {
    private static final Log LOG = LogFactory.getLog(FileSystemResource.class);
    private static final long STREAM_MINIMUM_THRESHOLD = 0x100000L;
    private final boolean stream;
    private final File file;
    private final String relativePath;
    private final Charset encoding;
    private final boolean detectEncoding;

    public FileSystemResource(Location location, String fileNameWithPath, Charset encoding, boolean stream) {
        this(location, fileNameWithPath, encoding, false, stream);
    }

    public FileSystemResource(Location location, String fileNameWithPath, Charset encoding, boolean detectEncoding, boolean stream) {
        this.file = new File(new File(fileNameWithPath).getPath());
        this.relativePath = location == null ? this.file.getPath() : location.getPathRelativeToThis(this.file.getPath()).replace("\\", "/");
        this.encoding = encoding;
        this.detectEncoding = detectEncoding;
        this.stream = stream;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getPath();
    }

    @Override
    public String getAbsolutePathOnDisk() {
        return this.file.getAbsolutePath();
    }

    @Override
    public Reader read() {
        Charset charSet = this.encoding;
        if (this.detectEncoding) {
            try {
                charSet = EncodingDetector.detectFileEncoding(this.file.toPath());
            }
            catch (IOException | FlywayEncodingDetectionException e) {
                LOG.debug("Could not auto detect encoding: " + e.getMessage());
            }
        }
        try {
            return Channels.newReader(FileChannel.open(this.file.toPath(), StandardOpenOption.READ), charSet.newDecoder(), 4096);
        }
        catch (IOException e) {
            LOG.debug("Unable to load filesystem resource" + this.file.getPath() + " using FileChannel.open. Falling back to FileInputStream implementation. Exception message: " + e.getMessage());
            try {
                return new BufferedReader(new BomStrippingReader(new InputStreamReader((InputStream)new FileInputStream(this.file), charSet)));
            }
            catch (IOException e2) {
                throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath() + " (encoding: " + charSet + ")", e2);
            }
        }
    }

    @Override
    public boolean shouldStream() {
        return this.stream && this.file.length() > 0x100000L;
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }
}

