/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.teams;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.core.api.FlywayException;

public class VaultUtils {
    public static String getConfiguration(String url, String token, String ... secrets) throws Exception {
        String urlWithoutSlash = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        StringBuilder vaultConf = new StringBuilder();
        for (String secret : secrets) {
            if (!secret.contains("/")) {
                vaultConf.append(VaultUtils.readSecret(urlWithoutSlash, token, secret)).append("\n");
                continue;
            }
            vaultConf.append(VaultUtils.readSecretWithPath(urlWithoutSlash, token, secret)).append("\n");
        }
        return vaultConf.toString();
    }

    private static String readSecretWithPath(String url, String token, String secret) throws Exception {
        if (!secret.startsWith("/")) {
            secret = "/" + secret;
        }
        String path = secret.substring(0, secret.lastIndexOf("/"));
        String secretName = secret.substring(secret.lastIndexOf("/") + 1);
        return VaultUtils.readSecret(url + path, token, secretName);
    }

    private static String readSecret(String url, String token, String secret) throws Exception {
        if (url.startsWith("https")) {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            return VaultUtils.readSecret(conn, token, secret);
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return VaultUtils.readSecret(conn, token, secret);
    }

    private static String readSecret(URLConnection conn, String token, String secret) throws Exception {
        JsonObject secretObj;
        JsonObject secretResponse = (JsonObject)new Gson().fromJson(VaultUtils.getSecretFromVault(conn, token), JsonObject.class);
        if (VaultUtils.isKV1Response(secretResponse)) {
            secretObj = secretResponse.getAsJsonObject("data");
        } else if (VaultUtils.isKV2Response(secretResponse)) {
            secretObj = secretResponse.getAsJsonObject("data").getAsJsonObject("data");
        } else {
            throw new FlywayException("Vault response unaccepted. Expected a KV1 or KV2 secret, but was: " + secretResponse);
        }
        if (!secretObj.has(secret)) {
            throw new FlywayException("'" + secret + "' is not a valid Vault secret");
        }
        return secretObj.get(secret).getAsString();
    }

    private static String getSecretFromVault(URLConnection conn, String token) throws Exception {
        conn.setRequestProperty("X-Vault-Token", token);
        StringBuilder rawSecret = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                rawSecret.append(line);
            }
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Vault secret location '" + conn.getURL() + "' could not be found. Ensure the path to your secret is correct.");
        }
        return rawSecret.toString();
    }

    private static boolean isKV1Response(JsonObject secretResponse) {
        JsonObject secretObj;
        try {
            secretObj = secretResponse.getAsJsonObject("data");
        }
        catch (ClassCastException e) {
            return false;
        }
        try {
            if (!secretObj.has("data")) {
                return true;
            }
            secretObj.getAsJsonObject("data");
            return false;
        }
        catch (ClassCastException e) {
            return true;
        }
    }

    private static boolean isKV2Response(JsonObject secretResponse) {
        try {
            secretResponse.getAsJsonObject("data").getAsJsonObject("data");
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

