/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Hashtable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public class TableNameInfo {
    private DataDictionary dd;
    private Hashtable<Long, ConglomerateDescriptor> ddCache;
    private Hashtable<UUID, TableDescriptor> tdCache;
    private Hashtable<Long, TableDescriptor> tableCache = new Hashtable(31);
    private Hashtable<Long, String> indexCache;

    public TableNameInfo(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        if (bl) {
            this.indexCache = new Hashtable(13);
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.dd = languageConnectionContext.getDataDictionary();
        this.ddCache = this.dd.hashAllConglomerateDescriptorsByNumber(transactionController);
        this.tdCache = this.dd.hashAllTableDescriptorsByTableId(transactionController);
    }

    public String getTableName(Long l) {
        if (l == null) {
            return "?";
        }
        TableDescriptor tableDescriptor = this.tableCache.get(l);
        if (tableDescriptor == null) {
            ConglomerateDescriptor conglomerateDescriptor = this.ddCache.get(l);
            if (conglomerateDescriptor != null) {
                tableDescriptor = this.tdCache.get(conglomerateDescriptor.getTableID());
            }
            if (conglomerateDescriptor == null || tableDescriptor == null) {
                Object object;
                if (l > 20L) {
                    object = "*** TRANSIENT_" + l;
                } else {
                    switch (l.intValue()) {
                        case 0: {
                            object = "*** INVALID CONGLOMERATE ***";
                            break;
                        }
                        case 1: {
                            object = "ConglomerateDirectory";
                            break;
                        }
                        case 2: {
                            object = "PropertyConglomerate";
                            break;
                        }
                        default: {
                            object = "*** INTERNAL TABLE " + l;
                        }
                    }
                }
                return object;
            }
            this.tableCache.put(l, tableDescriptor);
            if (this.indexCache != null && conglomerateDescriptor.isIndex()) {
                this.indexCache.put(l, conglomerateDescriptor.getConglomerateName());
            }
        }
        return tableDescriptor.getName();
    }

    public String getTableType(Long l) {
        String string;
        if (l == null) {
            return "?";
        }
        TableDescriptor tableDescriptor = this.tableCache.get(l);
        if (tableDescriptor != null) {
            switch (tableDescriptor.getTableType()) {
                case 0: {
                    string = "T";
                    break;
                }
                case 1: {
                    string = "S";
                    break;
                }
                default: {
                    string = "?";
                    break;
                }
            }
        } else {
            string = l > 20L ? "T" : "S";
        }
        return string;
    }

    public String getIndexName(Long l) {
        if (l == null) {
            return "?";
        }
        return this.indexCache.get(l);
    }
}

