/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

enum JdbcDataType {
    BOOL{

        @Override
        public int getSqlType() {
            return 16;
        }

        public Class<Boolean> getJavaClass() {
            return Boolean.class;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.BOOL;
        }

        public List<Boolean> getArrayElements(ResultSet rs, int columnIndex) {
            return rs.getBooleanList(columnIndex);
        }

        @Override
        public Type getSpannerType() {
            return Type.bool();
        }
    }
    ,
    BYTES{

        @Override
        public int getSqlType() {
            return -2;
        }

        public Class<byte[]> getJavaClass() {
            return byte[].class;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.BYTES;
        }

        public List<byte[]> getArrayElements(ResultSet rs, int columnIndex) {
            return JdbcTypeConverter.toJavaByteArrays(rs.getBytesList(columnIndex));
        }

        @Override
        public Type getSpannerType() {
            return Type.bytes();
        }
    }
    ,
    DATE{

        @Override
        public int getSqlType() {
            return 91;
        }

        public Class<Date> getJavaClass() {
            return Date.class;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.DATE;
        }

        public List<Date> getArrayElements(ResultSet rs, int columnIndex) {
            return JdbcTypeConverter.toSqlDates(rs.getDateList(columnIndex));
        }

        @Override
        public Type getSpannerType() {
            return Type.date();
        }
    }
    ,
    FLOAT64{
        private Set<Class<?>> classes = new HashSet<Class>(Arrays.asList(Float.class, Double.class));

        @Override
        public int getSqlType() {
            return 8;
        }

        public Class<Double> getJavaClass() {
            return Double.class;
        }

        public Set<Class<?>> getSupportedJavaClasses() {
            return this.classes;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.FLOAT64;
        }

        public List<Double> getArrayElements(ResultSet rs, int columnIndex) {
            return rs.getDoubleList(columnIndex);
        }

        @Override
        public Type getSpannerType() {
            return Type.float64();
        }
    }
    ,
    INT64{
        private Set<Class<?>> classes = new HashSet<Class>(Arrays.asList(Byte.class, Integer.class, Long.class));

        @Override
        public int getSqlType() {
            return -5;
        }

        public Class<Long> getJavaClass() {
            return Long.class;
        }

        public Set<Class<?>> getSupportedJavaClasses() {
            return this.classes;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.INT64;
        }

        public List<Long> getArrayElements(ResultSet rs, int columnIndex) {
            return rs.getLongList(columnIndex);
        }

        @Override
        public Type getSpannerType() {
            return Type.int64();
        }
    }
    ,
    NUMERIC{

        @Override
        public int getSqlType() {
            return 2;
        }

        public Class<BigDecimal> getJavaClass() {
            return BigDecimal.class;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.NUMERIC;
        }

        public List<BigDecimal> getArrayElements(ResultSet rs, int columnIndex) {
            return rs.getBigDecimalList(columnIndex);
        }

        @Override
        public Type getSpannerType() {
            return Type.numeric();
        }
    }
    ,
    STRING{

        @Override
        public int getSqlType() {
            return -9;
        }

        public Class<String> getJavaClass() {
            return String.class;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.STRING;
        }

        public List<String> getArrayElements(ResultSet rs, int columnIndex) {
            return rs.getStringList(columnIndex);
        }

        @Override
        public Type getSpannerType() {
            return Type.string();
        }
    }
    ,
    TIMESTAMP{

        @Override
        public int getSqlType() {
            return 93;
        }

        public Class<Timestamp> getJavaClass() {
            return Timestamp.class;
        }

        @Override
        public Type.Code getCode() {
            return Type.Code.TIMESTAMP;
        }

        public List<Timestamp> getArrayElements(ResultSet rs, int columnIndex) {
            return JdbcTypeConverter.toSqlTimestamps(rs.getTimestampList(columnIndex));
        }

        @Override
        public Type getSpannerType() {
            return Type.timestamp();
        }
    };


    public abstract int getSqlType();

    public abstract Type.Code getCode();

    public abstract Type getSpannerType();

    public abstract List<?> getArrayElements(ResultSet var1, int var2);

    public String getTypeName() {
        return this.name();
    }

    public abstract Class<?> getJavaClass();

    public Set<? extends Class<?>> getSupportedJavaClasses() {
        return Collections.singleton(this.getJavaClass());
    }

    public static JdbcDataType getType(Class<?> clazz) {
        for (JdbcDataType type : JdbcDataType.values()) {
            if (!type.getSupportedJavaClasses().contains(clazz)) continue;
            return type;
        }
        return null;
    }

    public static JdbcDataType getType(Type.Code code) {
        for (JdbcDataType type : JdbcDataType.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }
}

