/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;

public class SchemaObjectSet {
    HashMap map;
    int type;

    SchemaObjectSet(int n) {
        this.type = n;
        switch (n) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                this.map = new HashMappedList();
                break;
            }
            case 5: 
            case 20: {
                this.map = new HashMap();
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
    }

    HsqlNameManager.HsqlName getName(String string) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                SchemaObject schemaObject = (SchemaObject)this.map.get(string);
                return schemaObject == null ? null : schemaObject.getName();
            }
            case 5: 
            case 20: {
                return (HsqlNameManager.HsqlName)this.map.get(string);
            }
        }
        return (HsqlNameManager.HsqlName)this.map.get(string);
    }

    public SchemaObject getObject(String string) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                return (SchemaObject)this.map.get(string);
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }

    void checkAdd(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            int n = SchemaObjectSet.getAddErrorCode(hsqlName.type);
            throw Error.error(n, hsqlName.name);
        }
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    void checkExists(String string) {
        if (!this.map.containsKey(string)) {
            int n = SchemaObjectSet.getGetErrorCode(this.type);
            throw Error.error(n, string);
        }
    }

    public void add(SchemaObject schemaObject, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (this.type == 24) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!bl && this.map.containsKey(hsqlName.name)) {
            int n = SchemaObjectSet.getAddErrorCode(hsqlName.type);
            throw Error.error(n, hsqlName.name);
        }
        Object object = schemaObject;
        switch (hsqlName.type) {
            case 5: 
            case 20: {
                object = hsqlName;
                break;
            }
        }
        this.map.put(hsqlName.name, object);
    }

    void remove(String string) {
        this.map.remove(string);
    }

    void removeParent(HsqlNameManager.HsqlName hsqlName) {
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            if (this.type == 8 || this.type == 24) {
                object = (SchemaObject)iterator.next();
                if (object.getName().parent != hsqlName) continue;
                iterator.remove();
                continue;
            }
            object = (HsqlNameManager.HsqlName)iterator.next();
            if (((HsqlNameManager.HsqlName)object).parent != hsqlName) continue;
            iterator.remove();
        }
    }

    void rename(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        if (this.map.containsKey(hsqlName2.name)) {
            int n = SchemaObjectSet.getAddErrorCode(hsqlName.type);
            throw Error.error(n, hsqlName2.name);
        }
        switch (hsqlName2.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 32: {
                int n = ((HashMappedList)this.map).getIndex(hsqlName.name);
                if (n == -1) {
                    int n2 = SchemaObjectSet.getGetErrorCode(hsqlName.type);
                    throw Error.error(n2, hsqlName.name);
                }
                SchemaObject schemaObject = (SchemaObject)((HashMappedList)this.map).get(n);
                schemaObject.getName().rename(hsqlName2);
                ((HashMappedList)this.map).setKey(n, hsqlName2.name);
                break;
            }
            case 24: {
                int n = ((HashMappedList)this.map).getIndex(hsqlName.name);
                if (n == -1) {
                    int n3 = SchemaObjectSet.getGetErrorCode(hsqlName.type);
                    throw Error.error(n3, hsqlName.name);
                }
                Routine routine = (Routine)((HashMappedList)this.map).get(n);
                routine.getSpecificName().rename(hsqlName2);
                ((HashMappedList)this.map).setKey(n, hsqlName2.name);
                break;
            }
            case 5: 
            case 20: {
                this.map.remove(hsqlName.name);
                hsqlName.rename(hsqlName2);
                this.map.put(hsqlName.name, hsqlName);
                break;
            }
        }
    }

    static int getAddErrorCode(int n) {
        int n2;
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 5504;
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
        return n2;
    }

    static int getGetErrorCode(int n) {
        int n2;
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 5501;
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
        return n2;
    }

    public static String getName(int n) {
        switch (n) {
            case 4: {
                return "VIEW";
            }
            case 3: {
                return "TABLE";
            }
            case 7: {
                return "SEQUENCE";
            }
            case 14: {
                return "CHARACTER SET";
            }
            case 13: {
                return "DOMAIN";
            }
            case 12: {
                return "TYPE";
            }
            case 15: {
                return "COLLATION";
            }
            case 17: {
                return "PROCEDURE";
            }
            case 16: {
                return "FUNCTION";
            }
            case 24: {
                return "SPECIFIC ROUTINE";
            }
            case 6: {
                return "ASSERTION";
            }
            case 8: {
                return "TRIGGER";
            }
            case 32: {
                return "EXCEPTION";
            }
            case 31: {
                return "MODULE";
            }
            case 29: {
                return "SYNONYM";
            }
            case 23: {
                return "PARAMETER";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 20: {
                return "INDEX";
            }
            case 30: {
                return "PERIOD";
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    void getSQL(HsqlArrayList hsqlArrayList, OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        if (!(this.map instanceof HashMappedList)) {
            return;
        }
        if (this.map.isEmpty()) {
            return;
        }
        Iterator iterator = this.map.values().iterator();
        if (this.type == 16 || this.type == 17) {
            OrderedHashSet orderedHashSet3 = new OrderedHashSet();
            while (iterator.hasNext()) {
                RoutineSchema routineSchema = (RoutineSchema)iterator.next();
                for (int i = 0; i < routineSchema.routines.length; ++i) {
                    Routine routine = routineSchema.routines[i];
                    orderedHashSet3.add(routine);
                }
            }
            iterator = orderedHashSet3.iterator();
        }
        SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, iterator, null);
    }

    static void addAllSQL(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2, HsqlArrayList hsqlArrayList, Iterator iterator, OrderedHashSet orderedHashSet3) {
        block13: while (iterator.hasNext()) {
            ColumnSchema columnSchema;
            int n;
            Object object;
            OrderedHashSet orderedHashSet4;
            SchemaObject schemaObject = (SchemaObject)iterator.next();
            boolean bl = true;
            if (schemaObject.getType() == 3) {
                ((Table)schemaObject).setForwardConstraints(orderedHashSet);
                orderedHashSet4 = ((Table)schemaObject).getReferencesForScript();
            } else {
                orderedHashSet4 = schemaObject.getReferences();
            }
            block14: for (int i = 0; i < orderedHashSet4.size(); ++i) {
                object = (HsqlNameManager.HsqlName)orderedHashSet4.get(i);
                if (SqlInvariants.isSchemaNameSystem((HsqlNameManager.HsqlName)object)) continue;
                switch (((HsqlNameManager.HsqlName)object).type) {
                    case 3: {
                        if (orderedHashSet.contains(object)) continue block14;
                        bl = false;
                        continue block14;
                    }
                    case 9: {
                        if (schemaObject.getType() == 3) {
                            n = ((Table)schemaObject).findColumn(((HsqlNameManager.HsqlName)object).name);
                            columnSchema = ((Table)schemaObject).getColumn(n);
                            if (SchemaObjectSet.isChildObjectResolved(columnSchema, orderedHashSet)) continue block14;
                            bl = false;
                            continue block14;
                        }
                        if (orderedHashSet.contains(((HsqlNameManager.HsqlName)object).parent)) continue block14;
                        bl = false;
                        continue block14;
                    }
                    case 5: {
                        Constraint constraint;
                        if (((HsqlNameManager.HsqlName)object).parent != schemaObject.getName() || (constraint = ((Table)schemaObject).getConstraint(((HsqlNameManager.HsqlName)object).name)).getConstraintType() != 3 || SchemaObjectSet.isChildObjectResolved(constraint, orderedHashSet)) continue block14;
                        bl = false;
                        continue block14;
                    }
                    case 14: {
                        if (((HsqlNameManager.HsqlName)object).schema == null) continue block14;
                    }
                    case 7: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 24: {
                        if (orderedHashSet.contains(object)) continue block14;
                        bl = false;
                        continue block14;
                    }
                }
            }
            if (!bl) {
                orderedHashSet2.add(schemaObject);
                continue;
            }
            HsqlNameManager.HsqlName hsqlName = schemaObject.getType() == 16 || schemaObject.getType() == 17 ? ((Routine)schemaObject).getSpecificName() : schemaObject.getName();
            orderedHashSet.add(hsqlName);
            if (orderedHashSet3 != null) {
                orderedHashSet3.add(schemaObject);
            }
            switch (schemaObject.getType()) {
                case 3: {
                    hsqlArrayList.addAll(((Table)schemaObject).getSQL(orderedHashSet, orderedHashSet2));
                    object = schemaObject.getName().getCommentSQL("TABLE");
                    if (object != null) {
                        hsqlArrayList.add(object);
                    }
                    for (n = 0; n < ((Table)schemaObject).getColumnCount(); ++n) {
                        columnSchema = ((Table)schemaObject).getColumn(n);
                        object = columnSchema.getName().getCommentSQL("COLUMN");
                        if (object == null) continue;
                        hsqlArrayList.add(object);
                    }
                    continue block13;
                }
                case 16: 
                case 17: {
                    String string;
                    object = (Routine)schemaObject;
                    if (((Routine)object).isRecursive) {
                        hsqlArrayList.add(((Routine)schemaObject).getSQLDeclaration());
                        hsqlArrayList.add(((Routine)schemaObject).getSQLAlter());
                    } else {
                        hsqlArrayList.add(schemaObject.getSQL());
                    }
                    if ((string = schemaObject.getName().getCommentSQL("ROUTINE")) == null) continue block13;
                    hsqlArrayList.add(string);
                    break;
                }
                case 8: {
                    object = (TriggerDef)schemaObject;
                    hsqlArrayList.add(schemaObject.getSQL());
                    String string = schemaObject.getName().getCommentSQL("TRIGGER");
                    if (string == null) continue block13;
                    hsqlArrayList.add(string);
                    break;
                }
                case 7: {
                    hsqlArrayList.add(schemaObject.getSQL());
                    object = schemaObject.getName().getCommentSQL("SEQUENCE");
                    if (object == null) continue block13;
                    hsqlArrayList.add(object);
                    break;
                }
                default: {
                    hsqlArrayList.add(schemaObject.getSQL());
                }
            }
        }
    }

    static boolean isChildObjectResolved(SchemaObject schemaObject, OrderedHashSet orderedHashSet) {
        OrderedHashSet orderedHashSet2 = schemaObject.getReferences();
        for (int i = 0; i < orderedHashSet2.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
            if (SqlInvariants.isSchemaNameSystem(hsqlName) || orderedHashSet.contains(hsqlName)) continue;
            return false;
        }
        return true;
    }
}

